/*
 * Decompiled with CFR 0.152.
 */
package org.kitesdk.morphline.stdlib;

import com.google.common.collect.Maps;
import com.typesafe.config.Config;
import com.typesafe.config.ConfigFactory;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.kitesdk.morphline.api.Command;
import org.kitesdk.morphline.api.CommandBuilder;
import org.kitesdk.morphline.api.MorphlineContext;
import org.kitesdk.morphline.api.Record;
import org.kitesdk.morphline.base.AbstractCommand;
import org.kitesdk.morphline.base.Configs;
import org.kitesdk.morphline.base.Validator;
import org.kitesdk.morphline.shaded.com.google.code.regexp.GroupInfo;
import org.kitesdk.morphline.shaded.com.google.code.regexp.Matcher;
import org.kitesdk.morphline.stdlib.GrokDictionaries;

public final class GrokBuilder
implements CommandBuilder {
    @Override
    public Collection<String> getNames() {
        return Collections.singletonList("grok");
    }

    @Override
    public Command build(Config config, Command parent, Command child, MorphlineContext context) {
        return new Grok(this, config, parent, child, context);
    }

    private static final class Grok
    extends AbstractCommand {
        private final Map<String, Matcher> regexes = Maps.newHashMap();
        private final boolean extract;
        private final boolean extractInPlace;
        private final NumRequiredMatches numRequiredMatches;
        private final boolean findSubstrings;
        private final boolean addEmptyStrings;
        private final String firstKey;
        private final String renderedConfig;

        public Grok(CommandBuilder builder, Config config, Command parent, Command child, MorphlineContext context) {
            super(builder, config, parent, child, context);
            GrokDictionaries dict = new GrokDictionaries(config, this.getConfigs());
            Config exprConfig = this.getConfigs().getConfig(config, "expressions", ConfigFactory.empty());
            for (Map.Entry<String, Object> entry : new Configs().getEntrySet(exprConfig)) {
                String expr = entry.getValue().toString();
                this.regexes.put(entry.getKey(), dict.compileExpression(expr).matcher(""));
            }
            this.firstKey = this.regexes.size() == 0 ? null : this.regexes.entrySet().iterator().next().getKey();
            String extractStr = this.getConfigs().getString(config, "extract", "true");
            this.extractInPlace = extractStr.equals("inplace");
            this.extract = this.extractInPlace ? true : this.getConfigs().getBoolean(config, "extract", true);
            this.numRequiredMatches = (NumRequiredMatches)new Validator().validateEnum(config, this.getConfigs().getString(config, "numRequiredMatches", NumRequiredMatches.atLeastOnce.toString()), NumRequiredMatches.class, new NumRequiredMatches[0]);
            this.findSubstrings = this.getConfigs().getBoolean(config, "findSubstrings", false);
            this.addEmptyStrings = this.getConfigs().getBoolean(config, "addEmptyStrings", false);
            this.validateArguments();
            this.renderedConfig = config.root().render();
        }

        @Override
        protected boolean doProcess(Record inputRecord) {
            Record outputRecord;
            Record record = outputRecord = this.extractInPlace || !this.extract ? inputRecord : inputRecord.copy();
            if (this.extractInPlace) {
                boolean isFast;
                if (this.regexes.size() == 0) {
                    isFast = true;
                } else if (this.regexes.size() > 1) {
                    isFast = false;
                } else if (this.numRequiredMatches == NumRequiredMatches.atLeastOnce) {
                    isFast = true;
                } else {
                    assert (this.regexes.size() == 1);
                    assert (this.firstKey != null);
                    boolean bl = isFast = inputRecord.get(this.firstKey).size() <= 1;
                }
                if (!isFast && !this.doMatch(inputRecord, outputRecord, false)) {
                    return false;
                }
            }
            if (!this.doMatch(inputRecord, outputRecord, this.extract)) {
                return false;
            }
            return super.doProcess(outputRecord);
        }

        private boolean doMatch(Record inputRecord, Record outputRecord, boolean doExtract) {
            for (Map.Entry<String, Matcher> regexEntry : this.regexes.entrySet()) {
                Matcher matcher = regexEntry.getValue();
                List values = inputRecord.get(regexEntry.getKey());
                int todo = values.size();
                int minMatches = 1;
                int maxMatches = Integer.MAX_VALUE;
                switch (this.numRequiredMatches) {
                    case once: {
                        maxMatches = 1;
                        break;
                    }
                    case all: {
                        minMatches = todo;
                        break;
                    }
                }
                int numMatches = 0;
                for (Object value : values) {
                    matcher.reset(value.toString());
                    if (!this.findSubstrings) {
                        if (matcher.matches()) {
                            if (++numMatches > maxMatches) {
                                this.LOG.debug("grok failed because it found too many matches for values: {} for grok command: {}", (Object)values, (Object)this.renderedConfig);
                                return false;
                            }
                            this.extract(outputRecord, matcher, doExtract);
                        }
                    } else {
                        int previousNumMatches = numMatches;
                        while (matcher.find()) {
                            if (numMatches == previousNumMatches) {
                                if (++numMatches > maxMatches) {
                                    this.LOG.debug("grok failed because it found too many matches for values: {} for grok command: {}", (Object)values, (Object)this.renderedConfig);
                                    return false;
                                }
                                if (!doExtract && numMatches >= minMatches && maxMatches == Integer.MAX_VALUE) break;
                            }
                            this.extract(outputRecord, matcher, doExtract);
                        }
                    }
                    --todo;
                    if (doExtract || numMatches < minMatches || maxMatches != Integer.MAX_VALUE) continue;
                    break;
                }
                if (numMatches + todo >= minMatches) continue;
                this.LOG.debug("grok failed because it found too few matches for values: {} for grok command: {}", (Object)values, (Object)this.renderedConfig);
                return false;
            }
            return true;
        }

        private void extract(Record outputRecord, Matcher matcher, boolean doExtract) {
            if (doExtract) {
                this.extractFast(outputRecord, matcher);
            }
        }

        private void extractFast(Record outputRecord, Matcher matcher) {
            for (Map.Entry<String, List<GroupInfo>> entry : matcher.namedPattern().groupInfo().entrySet()) {
                String groupName = entry.getKey();
                List<GroupInfo> list = entry.getValue();
                int idx = list.get(0).groupIndex();
                int group = idx > -1 ? idx + 1 : -1;
                String value = matcher.group(group);
                if (value == null || value.length() <= 0 && !this.addEmptyStrings) continue;
                outputRecord.put(groupName, value);
            }
        }

        private static enum NumRequiredMatches {
            atLeastOnce,
            once,
            all;

        }
    }
}

