/*
 * Decompiled with CFR 0.152.
 */
package org.kitesdk.morphline.stdlib;

import com.typesafe.config.Config;
import java.util.Collections;
import java.util.List;
import org.kitesdk.morphline.api.Command;
import org.kitesdk.morphline.api.CommandBuilder;
import org.kitesdk.morphline.api.MorphlineContext;
import org.kitesdk.morphline.api.Record;
import org.kitesdk.morphline.base.AbstractCommand;
import org.kitesdk.morphline.base.FieldExpression;

abstract class LogCommand
extends AbstractCommand {
    private String format;
    private FieldExpression[] expressions;

    public LogCommand(CommandBuilder builder, Config config, Command parent, Command child, MorphlineContext context) {
        super(builder, config, parent, child, context);
        this.format = this.getConfigs().getString(config, "format");
        List<String> argList = this.getConfigs().getStringList(config, "args", Collections.<String>emptyList());
        this.expressions = new FieldExpression[argList.size()];
        for (int i = 0; i < argList.size(); ++i) {
            this.expressions[i] = new FieldExpression(argList.get(i), this.getConfig());
        }
        this.validateArguments();
    }

    @Override
    protected boolean doProcess(Record record) {
        Object[] resolvedArgs = new Object[this.expressions.length];
        for (int i = 0; i < this.expressions.length; ++i) {
            resolvedArgs[i] = this.expressions[i].evaluate(record);
        }
        this.log(this.format, resolvedArgs);
        return super.doProcess(record);
    }

    protected abstract void log(String var1, Object[] var2);
}

