/*
 * Decompiled with CFR 0.152.
 */
package org.kitesdk.morphline.stdlib;

import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.kitesdk.morphline.shaded.org.apache.hadoop.fs.GlobPattern;

final class PatternNameMatcher {
    private final Expression[] includes;
    private final Expression[] excludes;
    private final Set<String> includeLiterals = new HashSet<String>(16, 0.5f);
    private final Set<String> excludeLiterals = new HashSet<String>(16, 0.5f);

    public PatternNameMatcher(List<String> includeExpressions, List<String> excludeExpressions) {
        this.includes = this.parseExpressions(includeExpressions, this.includeLiterals);
        this.excludes = this.parseExpressions(excludeExpressions, this.excludeLiterals);
    }

    private Expression[] parseExpressions(List<String> expressions, Set<String> literals) {
        ArrayList<Expression> parsedExpressions = new ArrayList<Expression>();
        for (int i = 0; i < expressions.size(); ++i) {
            Expression expr = this.parseExpression(expressions.get(i), literals);
            if (expr == null) continue;
            parsedExpressions.add(expr);
        }
        return parsedExpressions.toArray(new Expression[parsedExpressions.size()]);
    }

    private Expression parseExpression(String expr, Set<String> literals) {
        int i;
        if (expr.equals("*")) {
            expr = "glob:*";
        }
        if ((i = expr.indexOf(58)) < 0) {
            throw new IllegalArgumentException("Illegal match expression: " + expr);
        }
        String type = expr.substring(0, i);
        String pattern = expr.substring(i + 1, expr.length());
        if (type.equals("literal")) {
            literals.add(pattern);
            return null;
        }
        if (type.equals("regex")) {
            if (pattern.equals(".*")) {
                return new MatchAllExpression();
            }
            return new RegexExpression(Pattern.compile(pattern));
        }
        if (type.equals("glob")) {
            if (pattern.equals("*")) {
                return new MatchAllExpression();
            }
            return new RegexExpression(GlobPattern.compile(pattern));
        }
        throw new IllegalArgumentException("Illegal match type: " + type);
    }

    public boolean matches(String name) {
        Preconditions.checkNotNull((Object)name);
        if (this.excludeLiterals.size() > 0 && this.excludeLiterals.contains(name)) {
            return false;
        }
        boolean isIncluded = this.includeLiterals.size() > 0 && this.includeLiterals.contains(name);
        for (int i = 0; !isIncluded && i < this.includes.length; ++i) {
            isIncluded = this.includes[i].matches(name);
        }
        if (!isIncluded) {
            return false;
        }
        for (Expression exclude : this.excludes) {
            if (!exclude.matches(name)) continue;
            return false;
        }
        return true;
    }

    private static final class BoundedLRUHashMap<K, V>
    extends LinkedHashMap<K, V> {
        private final int capacity;

        private BoundedLRUHashMap(int capacity) {
            super(16, 0.5f, true);
            this.capacity = capacity;
        }

        @Override
        protected boolean removeEldestEntry(Map.Entry eldest) {
            return this.size() > this.capacity;
        }
    }

    private static final class RegexExpression
    implements Expression {
        private final Matcher regex;
        private final Map<String, Boolean> cache = new BoundedLRUHashMap<String, Boolean>(10000);

        public RegexExpression(Pattern pattern) {
            this.regex = pattern.matcher("");
        }

        @Override
        public boolean matches(String str) {
            Boolean isMatch = this.cache.get(str);
            if (isMatch == null) {
                isMatch = this.regex.reset(str).matches();
                this.cache.put(str, isMatch);
            }
            return isMatch;
        }
    }

    private static final class MatchAllExpression
    implements Expression {
        private MatchAllExpression() {
        }

        @Override
        public boolean matches(String str) {
            return true;
        }
    }

    private static interface Expression {
        public boolean matches(String var1);
    }
}

