/*
 * Decompiled with CFR 0.152.
 */
package org.kitesdk.morphline.api;

import java.util.Map;

public final class TypedSettings {
    public static final String DRY_RUN_SETTING_NAME = "isDryRun";
    public static final String TASK_CONTEXT_SETTING_NAME = "taskContext";
    private final Map<String, Object> map;

    TypedSettings(Map<String, Object> map) {
        this.map = map;
    }

    public String getString(String key, String defaultValue) {
        Object value = this.map.get(key);
        if (value == null) {
            return defaultValue;
        }
        if (value instanceof String) {
            return (String)value;
        }
        throw new ClassCastException(this.errorMessage(key, value, "String"));
    }

    public boolean getBoolean(String key, boolean defaultValue) {
        Object value = this.map.get(key);
        if (value == null) {
            return defaultValue;
        }
        if (value instanceof Boolean) {
            return (Boolean)value;
        }
        if (value instanceof String) {
            return Boolean.parseBoolean((String)value);
        }
        throw new ClassCastException(this.errorMessage(key, value, "boolean"));
    }

    public int getInt(String key, int defaultValue) {
        Object value = this.map.get(key);
        if (value == null) {
            return defaultValue;
        }
        if (value instanceof Integer) {
            return (Integer)value;
        }
        if (value instanceof String) {
            return Integer.parseInt((String)value);
        }
        throw new ClassCastException(this.errorMessage(key, value, "integer"));
    }

    public long getLong(String key, int defaultValue) {
        Object value = this.map.get(key);
        if (value == null) {
            return defaultValue;
        }
        if (value instanceof Long) {
            return (Long)value;
        }
        if (value instanceof String) {
            return Long.parseLong((String)value);
        }
        throw new ClassCastException(this.errorMessage(key, value, "long"));
    }

    public double getDouble(String key, double defaultValue) {
        Object value = this.map.get(key);
        if (value == null) {
            return defaultValue;
        }
        if (value instanceof Double) {
            return (Double)value;
        }
        if (value instanceof String) {
            return Double.parseDouble((String)value);
        }
        throw new ClassCastException(this.errorMessage(key, value, "double"));
    }

    public float getFloat(String key, float defaultValue) {
        Object value = this.map.get(key);
        if (value == null) {
            return defaultValue;
        }
        if (value instanceof Float) {
            return ((Float)value).floatValue();
        }
        if (value instanceof String) {
            return Float.parseFloat((String)value);
        }
        throw new ClassCastException(this.errorMessage(key, value, "float"));
    }

    public Object getObject(String key, Object defaultValue) {
        Object value = this.map.get(key);
        if (value == null) {
            return defaultValue;
        }
        return value;
    }

    private String errorMessage(String key, Object value, String type) {
        return "key:value " + key + ":" + value + " cannot be converted to a " + type;
    }
}

