/*
 * Decompiled with CFR 0.152.
 */
package org.kitesdk.morphline.stdio;

import com.typesafe.config.Config;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.Collections;
import org.kitesdk.morphline.api.Command;
import org.kitesdk.morphline.api.CommandBuilder;
import org.kitesdk.morphline.api.MorphlineContext;
import org.kitesdk.morphline.api.Record;
import org.kitesdk.morphline.stdio.AbstractParser;

public final class ReadBlobBuilder
implements CommandBuilder {
    @Override
    public Collection<String> getNames() {
        return Collections.singletonList("readBlob");
    }

    @Override
    public Command build(Config config, Command parent, Command child, MorphlineContext context) {
        return new ReadBlob(this, config, parent, child, context);
    }

    private static final class ReadBlob
    extends AbstractParser {
        private final String outputFieldName;
        private final byte[] buffer = new byte[8192];
        private ByteArrayOutputStream blob = null;
        private int counter = 0;

        public ReadBlob(CommandBuilder builder, Config config, Command parent, Command child, MorphlineContext context) {
            super(builder, config, parent, child, context);
            this.outputFieldName = this.getConfigs().getString(config, "outputField", "_attachment_body");
            this.validateArguments();
        }

        @Override
        protected boolean doProcess(Record inputRecord, InputStream stream) throws IOException {
            int len;
            if (this.counter++ % 8192 == 0) {
                this.blob = new ByteArrayOutputStream(8192);
            }
            this.incrementNumRecords();
            this.blob.reset();
            while ((len = stream.read(this.buffer)) >= 0) {
                this.blob.write(this.buffer, 0, len);
            }
            inputRecord.replaceValues(this.outputFieldName, this.blob.toByteArray());
            return this.getChild().process(inputRecord);
        }
    }
}

