/*
 * Decompiled with CFR 0.152.
 */
package org.kitesdk.morphline.stdlib;

import com.typesafe.config.Config;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.kitesdk.morphline.api.Command;
import org.kitesdk.morphline.api.CommandBuilder;
import org.kitesdk.morphline.api.MorphlineContext;
import org.kitesdk.morphline.api.Record;
import org.kitesdk.morphline.base.AbstractCommand;
import org.kitesdk.morphline.base.Configs;
import org.kitesdk.morphline.base.FieldExpression;

public final class EqualsBuilder
implements CommandBuilder {
    @Override
    public Collection<String> getNames() {
        return Collections.singletonList("equals");
    }

    @Override
    public Command build(Config config, Command parent, Command child, MorphlineContext context) {
        return new Equals(this, config, parent, child, context);
    }

    private static final class Equals
    extends AbstractCommand {
        private final Set<Map.Entry<String, Object>> entrySet;
        private final String renderedConfig;

        public Equals(CommandBuilder builder, Config config, Command parent, Command child, MorphlineContext context) {
            super(builder, config, parent, child, context);
            this.entrySet = new Configs().getEntrySet(config);
            for (Map.Entry<String, Object> entry : this.entrySet) {
                if (entry.getValue() instanceof Collection) continue;
                entry.setValue(new FieldExpression(entry.getValue().toString(), this.getConfig()));
            }
            this.renderedConfig = config.root().render();
        }

        @Override
        protected boolean doProcess(Record record) {
            for (Map.Entry<String, Object> entry : this.entrySet) {
                Object entryValue;
                Collection results;
                String fieldName = entry.getKey();
                List values = record.get(fieldName);
                if (values.equals(results = (entryValue = entry.getValue()) instanceof Collection ? (Collection)entryValue : ((FieldExpression)entryValue).evaluate(record))) continue;
                if (this.LOG.isDebugEnabled()) {
                    this.LOG.debug("Equals command failed because {} does not match values: {} for command: {}", new Object[]{results, values, this.renderedConfig});
                }
                return false;
            }
            return super.doProcess(record);
        }
    }
}

