/*
 * Decompiled with CFR 0.152.
 */
package org.kitesdk.morphline.stdlib;

import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.kitesdk.morphline.shaded.org.apache.hadoop.fs.GlobPattern;

final class PatternNameMatcher {
    private final Expression[] includes;
    private final Expression[] excludes;
    private Set<String> includeLiterals = new HashSet<String>(16, 0.5f);
    private Set<String> excludeLiterals = new HashSet<String>(16, 0.5f);
    private final String[] literalsOnly;

    public PatternNameMatcher(List<String> includeExpressions, List<String> excludeExpressions, int cacheCapacity) {
        this.includes = this.parseExpressions(includeExpressions, this.includeLiterals, cacheCapacity);
        this.excludes = this.parseExpressions(excludeExpressions, this.excludeLiterals, cacheCapacity);
        this.includeLiterals.removeAll(this.excludeLiterals);
        this.includeLiterals = this.optimize(this.includeLiterals);
        this.excludeLiterals = this.optimize(this.excludeLiterals);
        this.literalsOnly = this.includes.length == 0 && this.excludes.length == 0 ? this.includeLiterals.toArray(new String[this.includeLiterals.size()]) : null;
    }

    public String[] getLiteralsOnly() {
        return this.literalsOnly;
    }

    private Set<String> optimize(Set<String> items) {
        if (items.size() == 1) {
            return Collections.singleton(items.iterator().next());
        }
        return items;
    }

    private Expression[] parseExpressions(List<String> expressions, Set<String> literals, int cacheCapacity) {
        ArrayList<Expression> parsedExpressions = new ArrayList<Expression>();
        for (int i = 0; i < expressions.size(); ++i) {
            Expression expr = this.parseExpression(expressions.get(i), literals, cacheCapacity);
            if (expr == null) continue;
            parsedExpressions.add(expr);
        }
        return parsedExpressions.toArray(new Expression[parsedExpressions.size()]);
    }

    private Expression parseExpression(String expr, Set<String> literals, int cacheCapacity) {
        int i;
        if (expr.equals("*")) {
            expr = "glob:*";
        }
        if ((i = expr.indexOf(58)) < 0) {
            throw new IllegalArgumentException("Illegal match expression: " + expr);
        }
        String type = expr.substring(0, i);
        String pattern = expr.substring(i + 1, expr.length());
        if (type.equals("literal")) {
            literals.add(pattern);
            return null;
        }
        if (type.equals("regex")) {
            if (pattern.equals(".*")) {
                return new MatchAllExpression();
            }
            return new RegexExpression(Pattern.compile(pattern), cacheCapacity);
        }
        if (type.equals("glob")) {
            if (pattern.equals("*")) {
                return new MatchAllExpression();
            }
            return new RegexExpression(GlobPattern.compile(pattern), cacheCapacity);
        }
        throw new IllegalArgumentException("Illegal match type: " + type);
    }

    public boolean matches(String name) {
        Preconditions.checkNotNull((Object)name);
        if (this.excludeLiterals.size() > 0 && this.excludeLiterals.contains(name)) {
            return false;
        }
        boolean isIncluded = this.includeLiterals.size() > 0 && this.includeLiterals.contains(name);
        for (int i = 0; !isIncluded && i < this.includes.length; ++i) {
            isIncluded = this.includes[i].matches(name);
        }
        if (!isIncluded) {
            return false;
        }
        for (Expression exclude : this.excludes) {
            if (!exclude.matches(name)) continue;
            return false;
        }
        return true;
    }

    private static final class BoundedLRUHashMap<K, V>
    extends LinkedHashMap<K, V> {
        private final int capacity;

        private BoundedLRUHashMap(int capacity) {
            super(16, 0.5f, true);
            this.capacity = capacity;
        }

        @Override
        protected boolean removeEldestEntry(Map.Entry eldest) {
            return this.size() > this.capacity;
        }
    }

    private static final class RegexExpression
    implements Expression {
        private final Matcher regex;
        private final Map<String, Boolean> cache;

        public RegexExpression(Pattern pattern, int cacheCapacity) {
            this.regex = pattern.matcher("");
            if (cacheCapacity < 0) {
                throw new IllegalArgumentException("Cache capacity must not be negative");
            }
            this.cache = cacheCapacity > 0 ? new BoundedLRUHashMap(cacheCapacity) : null;
        }

        @Override
        public boolean matches(String str) {
            if (this.cache == null) {
                return this.regex.reset(str).matches();
            }
            Boolean isMatch = this.cache.get(str);
            if (isMatch == null) {
                isMatch = this.regex.reset(str).matches();
                this.cache.put(str, isMatch);
            }
            return isMatch;
        }
    }

    private static final class MatchAllExpression
    implements Expression {
        private MatchAllExpression() {
        }

        @Override
        public boolean matches(String str) {
            return true;
        }
    }

    private static interface Expression {
        public boolean matches(String var1);
    }
}

