/*
 * Decompiled with CFR 0.152.
 */
package org.kitesdk.morphline.stdlib;

import com.typesafe.config.Config;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.kitesdk.morphline.api.Command;
import org.kitesdk.morphline.api.CommandBuilder;
import org.kitesdk.morphline.api.MorphlineContext;
import org.kitesdk.morphline.api.Record;
import org.kitesdk.morphline.base.AbstractCommand;
import org.kitesdk.morphline.stdlib.PatternNameMatcher;

public final class RemoveFieldsBuilder
implements CommandBuilder {
    @Override
    public Collection<String> getNames() {
        return Collections.singletonList("removeFields");
    }

    @Override
    public Command build(Config config, Command parent, Command child, MorphlineContext context) {
        return new RemoveFields(this, config, parent, child, context);
    }

    private static final class RemoveFields
    extends AbstractCommand {
        private final PatternNameMatcher nameMatcher;

        public RemoveFields(CommandBuilder builder, Config config, Command parent, Command child, MorphlineContext context) {
            super(builder, config, parent, child, context);
            List<String> includes = this.getConfigs().getStringList(config, "blacklist", Collections.singletonList("*"));
            List<String> excludes = this.getConfigs().getStringList(config, "whitelist", Collections.<String>emptyList());
            this.nameMatcher = new PatternNameMatcher(includes, excludes, 10000);
            this.validateArguments();
        }

        @Override
        protected boolean doProcess(Record record) {
            if (this.nameMatcher.getLiteralsOnly() == null) {
                this.doProcessSlow(record);
            } else {
                this.doProcessFast(record);
            }
            return super.doProcess(record);
        }

        private void doProcessSlow(Record record) {
            Iterator iter = record.getFields().asMap().keySet().iterator();
            while (iter.hasNext()) {
                if (!this.nameMatcher.matches((String)iter.next())) continue;
                iter.remove();
            }
        }

        private void doProcessFast(Record record) {
            for (String name : this.nameMatcher.getLiteralsOnly()) {
                record.removeAll(name);
            }
        }
    }
}

