/*
 * Decompiled with CFR 0.152.
 */
package org.kitesdk.morphline.stdlib;

import com.typesafe.config.Config;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.kitesdk.morphline.api.Command;
import org.kitesdk.morphline.api.CommandBuilder;
import org.kitesdk.morphline.api.MorphlineContext;
import org.kitesdk.morphline.api.Record;
import org.kitesdk.morphline.base.AbstractCommand;
import org.kitesdk.morphline.stdlib.PatternNameMatcher;

public final class RemoveValuesBuilder
implements CommandBuilder {
    @Override
    public Collection<String> getNames() {
        return Collections.singletonList("removeValues");
    }

    @Override
    public Command build(Config config, Command parent, Command child, MorphlineContext context) {
        return new RemoveValues(this, config, parent, child, context);
    }

    private static final class RemoveValues
    extends AbstractCommand {
        private final PatternNameMatcher nameMatcher;
        private final PatternNameMatcher valueMatcher;

        public RemoveValues(CommandBuilder builder, Config config, Command parent, Command child, MorphlineContext context) {
            super(builder, config, parent, child, context);
            List<String> nameBlacklist = this.getConfigs().getStringList(config, "nameBlacklist", Collections.singletonList("*"));
            List<String> nameWhitelist = this.getConfigs().getStringList(config, "nameWhitelist", Collections.<String>emptyList());
            List<String> valueBlacklist = this.getConfigs().getStringList(config, "valueBlacklist", Collections.singletonList("*"));
            List<String> valueWhitelist = this.getConfigs().getStringList(config, "valueWhitelist", Collections.<String>emptyList());
            this.nameMatcher = new PatternNameMatcher(nameBlacklist, nameWhitelist, 10000);
            this.valueMatcher = new PatternNameMatcher(valueBlacklist, valueWhitelist, 0);
            this.validateArguments();
        }

        @Override
        protected boolean doProcess(Record record) {
            if (this.nameMatcher.getLiteralsOnly() == null) {
                this.doProcessSlow(record);
            } else {
                this.doProcessFast(record);
            }
            return super.doProcess(record);
        }

        private void doProcessSlow(Record record) {
            Iterator iter = record.getFields().asMap().entrySet().iterator();
            while (iter.hasNext()) {
                Map.Entry entry = iter.next();
                if (!this.nameMatcher.matches((String)entry.getKey())) continue;
                List values = (List)entry.getValue();
                int i = values.size();
                while (--i >= 0) {
                    if (!this.valueMatcher.matches(values.get(i).toString())) continue;
                    if (values.size() > 1) {
                        values.remove(i);
                        continue;
                    }
                    iter.remove();
                }
            }
        }

        private void doProcessFast(Record record) {
            for (String name : this.nameMatcher.getLiteralsOnly()) {
                List values = record.get(name);
                int i = values.size();
                while (--i >= 0) {
                    if (!this.valueMatcher.matches(values.get(i).toString())) continue;
                    values.remove(i);
                }
            }
        }
    }
}

