/*
 * Decompiled with CFR 0.152.
 */
package org.kitesdk.morphline.stdlib;

import com.codahale.metrics.JmxReporter;
import com.codahale.metrics.MetricFilter;
import com.codahale.metrics.MetricRegistry;
import com.google.common.collect.Maps;
import com.typesafe.config.Config;
import com.typesafe.config.ConfigFactory;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.kitesdk.morphline.api.Command;
import org.kitesdk.morphline.api.CommandBuilder;
import org.kitesdk.morphline.api.MorphlineContext;
import org.kitesdk.morphline.api.Record;
import org.kitesdk.morphline.base.AbstractCommand;
import org.kitesdk.morphline.base.Configs;
import org.kitesdk.morphline.base.Notifications;
import org.kitesdk.morphline.stdlib.PatternMetricFilter;

public final class StartReportingMetricsToJMXBuilder
implements CommandBuilder {
    @Override
    public Collection<String> getNames() {
        return Collections.singletonList("startReportingMetricsToJMX");
    }

    @Override
    public Command build(Config config, Command parent, Command child, MorphlineContext context) {
        return new StartReportingMetricsToJMX(this, config, parent, child, context);
    }

    private static final class StartReportingMetricsToJMX
    extends AbstractCommand {
        private final String domain;
        private static final Map<MetricRegistry, Map<String, JmxReporter>> REGISTRIES = Maps.newIdentityHashMap();

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public StartReportingMetricsToJMX(CommandBuilder builder, Config config, Command parent, Command child, MorphlineContext context) {
            super(builder, config, parent, child, context);
            MetricFilter filter = PatternMetricFilter.parse(this.getConfigs(), config);
            TimeUnit defaultDurationUnit = this.getConfigs().getTimeUnit(config, "defaultDurationUnit", TimeUnit.MILLISECONDS);
            TimeUnit defaultRateUnit = this.getConfigs().getTimeUnit(config, "defaultRateUnit", TimeUnit.SECONDS);
            HashMap durationUnits = Maps.newHashMap();
            Config durationUnitsConfig = this.getConfigs().getConfig(config, "durationUnits", ConfigFactory.empty());
            for (Map.Entry<String, Object> entry : new Configs().getEntrySet(durationUnitsConfig)) {
                TimeUnit unit = new Configs().getTimeUnit(entry.getValue().toString());
                durationUnits.put(entry.getKey(), unit);
            }
            HashMap rateUnits = Maps.newHashMap();
            Config rateUnitsConfig = this.getConfigs().getConfig(config, "rateUnits", ConfigFactory.empty());
            for (Map.Entry<String, Object> entry : new Configs().getEntrySet(rateUnitsConfig)) {
                TimeUnit unit = new Configs().getTimeUnit(entry.getValue().toString());
                rateUnits.put(entry.getKey(), unit);
            }
            this.domain = this.getConfigs().getString(config, "domain", "metrics");
            this.validateArguments();
            MetricRegistry registry = context.getMetricRegistry();
            Map<MetricRegistry, Map<String, JmxReporter>> map = REGISTRIES;
            synchronized (map) {
                JmxReporter reporter;
                HashMap reporters = REGISTRIES.get(registry);
                if (reporters == null) {
                    reporters = Maps.newHashMap();
                    REGISTRIES.put(registry, reporters);
                }
                if ((reporter = (JmxReporter)reporters.get(this.domain)) == null) {
                    JmxReporter.Builder reporterBuilder = JmxReporter.forRegistry((MetricRegistry)registry).filter(filter).convertDurationsTo(defaultDurationUnit).convertRatesTo(defaultRateUnit).specificDurationUnits((Map)durationUnits).specificRateUnits((Map)rateUnits).inDomain(this.domain);
                    reporter = reporterBuilder.build();
                    reporter.start();
                    reporters.put(this.domain, reporter);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void doNotify(Record notification) {
            for (Object event : Notifications.getLifecycleEvents(notification)) {
                if (event != Notifications.LifecycleEvent.SHUTDOWN) continue;
                Map<MetricRegistry, Map<String, JmxReporter>> map = REGISTRIES;
                synchronized (map) {
                    JmxReporter reporter;
                    Map<String, JmxReporter> reporters = REGISTRIES.get(this.getContext().getMetricRegistry());
                    if (reporters != null && (reporter = reporters.remove(this.domain)) != null) {
                        reporter.stop();
                    }
                }
            }
            super.doNotify(notification);
        }
    }
}

