/*
 * Decompiled with CFR 0.152.
 */
package org.kitesdk.morphline.hadoop.core;

import com.typesafe.config.Config;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.FileUtil;
import org.apache.hadoop.fs.Path;
import org.kitesdk.morphline.api.Command;
import org.kitesdk.morphline.api.CommandBuilder;
import org.kitesdk.morphline.api.MorphlineCompilationException;
import org.kitesdk.morphline.api.MorphlineContext;
import org.kitesdk.morphline.base.AbstractCommand;
import org.kitesdk.morphline.hadoop.core.FileUtils;

public final class DownloadHdfsFileBuilder
implements CommandBuilder {
    public Collection<String> getNames() {
        return Collections.singletonList("downloadHdfsFile");
    }

    public Command build(Config config, Command parent, Command child, MorphlineContext context) {
        try {
            return new DownloadHdfsFile(this, config, parent, child, context);
        }
        catch (IOException e) {
            throw new MorphlineCompilationException("Cannot compile", config, (Throwable)e);
        }
    }

    private static final class DownloadHdfsFile
    extends AbstractCommand {
        private static final Set<String> DONE = new HashSet<String>();

        public DownloadHdfsFile(CommandBuilder builder, Config config, Command parent, Command child, MorphlineContext context) throws IOException {
            super(builder, config, parent, child, context);
            List uris = this.getConfigs().getStringList(config, "inputFiles", Collections.emptyList());
            File dstRootDir = new File(this.getConfigs().getString(config, "outputDir", "."));
            Configuration conf = new Configuration();
            String defaultFileSystemUri = this.getConfigs().getString(config, "fs", null);
            if (defaultFileSystemUri != null) {
                FileSystem.setDefaultUri((Configuration)conf, (String)defaultFileSystemUri);
            }
            for (String value : this.getConfigs().getStringList(config, "conf", Collections.emptyList())) {
                conf.addResource(new Path(value));
            }
            this.validateArguments();
            this.download(uris, conf, dstRootDir);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void download(List<String> uris, Configuration conf, File dstRootDir) throws IOException {
            Set<String> set = DONE;
            synchronized (set) {
                for (String uri : uris) {
                    FileSystem fs;
                    Path path = new Path(uri);
                    File dst = new File(dstRootDir, path.getName()).getCanonicalFile();
                    if (DONE.contains(dst.getPath())) continue;
                    if (dst.isDirectory()) {
                        this.LOG.debug("Deleting dir {}", (Object)dst);
                        FileUtils.deleteDirectory(dst);
                    }
                    if ((fs = path.getFileSystem(conf)).isFile(path)) {
                        dst.getParentFile().mkdirs();
                    }
                    this.LOG.debug("Downloading {} to {}", (Object)uri, (Object)dst);
                    if (!FileUtil.copy((FileSystem)fs, (Path)path, (File)dst, (boolean)false, (Configuration)conf)) {
                        throw new IOException("Cannot download URI " + uri + " to " + dst);
                    }
                    DONE.add(dst.getPath());
                    this.LOG.debug("Succeeded downloading {} to {}", (Object)uri, (Object)dst);
                }
            }
        }
    }
}

