/*
 * Decompiled with CFR 0.152.
 */
package org.kitesdk.morphline.hadoop.core;

import com.typesafe.config.Config;
import java.io.BufferedInputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.Collections;
import java.util.zip.GZIPInputStream;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.kitesdk.morphline.api.Command;
import org.kitesdk.morphline.api.CommandBuilder;
import org.kitesdk.morphline.api.MorphlineContext;
import org.kitesdk.morphline.api.MorphlineRuntimeException;
import org.kitesdk.morphline.api.Record;
import org.kitesdk.morphline.base.AbstractCommand;
import org.kitesdk.morphline.shaded.com.google.common.io.Closeables;
import org.kitesdk.morphline.stdio.AbstractParser;

public final class OpenHdfsFileBuilder
implements CommandBuilder {
    public Collection<String> getNames() {
        return Collections.singletonList("openHdfsFile");
    }

    public Command build(Config config, Command parent, Command child, MorphlineContext context) {
        return new OpenHdfsFile(this, config, parent, child, context);
    }

    private static final class OpenHdfsFile
    extends AbstractCommand {
        private final Configuration conf = new Configuration();

        public OpenHdfsFile(CommandBuilder builder, Config config, Command parent, Command child, MorphlineContext context) {
            super(builder, config, parent, child, context);
            String defaultFileSystemUri = this.getConfigs().getString(config, "fs", null);
            if (defaultFileSystemUri != null) {
                FileSystem.setDefaultUri((Configuration)this.conf, (String)defaultFileSystemUri);
            }
            for (String value : this.getConfigs().getStringList(config, "conf", Collections.emptyList())) {
                this.conf.addResource(new Path(value));
            }
            this.validateArguments();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected boolean doProcess(Record record) {
            for (Object body : record.get("_attachment_body")) {
                Object in;
                block6: {
                    boolean bl;
                    Record outputRecord = record.copy();
                    AbstractParser.removeAttachments((Record)outputRecord);
                    String pathString = body.toString();
                    Path path = new Path(pathString);
                    in = null;
                    try {
                        try {
                            FileSystem fs = path.getFileSystem(this.conf);
                            in = fs.open(path);
                            if (pathString.endsWith(".gz")) {
                                in = new GZIPInputStream((InputStream)in, 65536);
                            }
                            in = new BufferedInputStream((InputStream)in);
                            outputRecord.put("_attachment_body", in);
                        }
                        catch (IOException e) {
                            throw new MorphlineRuntimeException((Throwable)e);
                        }
                        if (this.getChild().process(outputRecord)) break block6;
                        bl = false;
                    }
                    catch (Throwable throwable) {
                        Closeables.closeQuietly(in);
                        throw throwable;
                    }
                    Closeables.closeQuietly((Closeable)in);
                    return bl;
                }
                Closeables.closeQuietly((Closeable)in);
            }
            return true;
        }
    }
}

