/*
 * Decompiled with CFR 0.152.
 */
package org.kitesdk.morphline.hadoop.parquet.avro;

import com.codahale.metrics.Meter;
import com.typesafe.config.Config;
import java.io.Closeable;
import java.io.EOFException;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericContainer;
import org.apache.avro.generic.IndexedRecord;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.kitesdk.morphline.api.Command;
import org.kitesdk.morphline.api.CommandBuilder;
import org.kitesdk.morphline.api.MorphlineCompilationException;
import org.kitesdk.morphline.api.MorphlineContext;
import org.kitesdk.morphline.api.MorphlineRuntimeException;
import org.kitesdk.morphline.api.Record;
import org.kitesdk.morphline.base.AbstractCommand;
import org.kitesdk.morphline.shaded.com.google.common.io.Closeables;
import org.kitesdk.morphline.stdio.AbstractParser;
import parquet.avro.AvroParquetReader;
import parquet.avro.AvroReadSupport;

public final class ReadAvroParquetFileBuilder
implements CommandBuilder {
    public static final String FILE_UPLOAD_URL = "file_upload_url";
    public static final String AVRO_MEMORY_MIME_TYPE = "avro/java+memory";

    public Collection<String> getNames() {
        return Collections.singletonList("readAvroParquetFile");
    }

    public Command build(Config config, Command parent, Command child, MorphlineContext context) {
        return new ReadAvroParquetFile(this, config, parent, child, context);
    }

    private static final class ReadAvroParquetFile
    extends AbstractCommand {
        private final Configuration conf = new Configuration();
        private final Meter numRecordsMeter;

        public ReadAvroParquetFile(CommandBuilder builder, Config config, Command parent, Command child, MorphlineContext context) {
            super(builder, config, parent, child, context);
            Schema readerSchema;
            String readerSchemaString;
            Schema projectionSchema;
            String defaultFileSystemUri = this.getConfigs().getString(config, "fs", null);
            if (defaultFileSystemUri != null) {
                FileSystem.setDefaultUri((Configuration)this.conf, (String)defaultFileSystemUri);
            }
            for (String value : this.getConfigs().getStringList(config, "conf", Collections.emptyList())) {
                this.conf.addResource(new Path(value));
            }
            String projectionSchemaString = this.getConfigs().getString(config, "projectionSchemaString", null);
            if (projectionSchemaString != null) {
                projectionSchema = new Schema.Parser().parse(projectionSchemaString);
            } else {
                String projectionSchemaFile = this.getConfigs().getString(config, "projectionSchemaFile", null);
                if (projectionSchemaFile != null) {
                    try {
                        projectionSchema = new Schema.Parser().parse(new File(projectionSchemaFile));
                    }
                    catch (IOException e) {
                        throw new MorphlineCompilationException("Cannot parse external Avro projection schema file: " + projectionSchemaFile, config, (Throwable)e);
                    }
                } else {
                    projectionSchema = null;
                }
            }
            if (projectionSchema != null) {
                AvroReadSupport.setRequestedProjection((Configuration)this.conf, (Schema)projectionSchema);
            }
            if ((readerSchemaString = this.getConfigs().getString(config, "readerSchemaString", null)) != null) {
                readerSchema = new Schema.Parser().parse(readerSchemaString);
            } else {
                String readerSchemaFile = this.getConfigs().getString(config, "readerSchemaFile", null);
                if (readerSchemaFile != null) {
                    try {
                        readerSchema = new Schema.Parser().parse(new File(readerSchemaFile));
                    }
                    catch (IOException e) {
                        throw new MorphlineCompilationException("Cannot parse external Avro reader schema file: " + readerSchemaFile, config, (Throwable)e);
                    }
                } else {
                    readerSchema = null;
                }
            }
            if (readerSchema != null) {
                AvroReadSupport.setAvroReadSchema((Configuration)this.conf, (Schema)readerSchema);
            }
            this.numRecordsMeter = this.getMeter(new String[]{"numRecords"});
            this.validateArguments();
        }

        /*
         * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
         * Unable to fully structure code
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        protected boolean doProcess(Record inputRecord) {
            paths = inputRecord.get("file_upload_url");
            if (paths.size() == 0) {
                return false;
            }
            obj = paths.get(0);
            path = obj instanceof Path != false ? (Path)obj : new Path(obj.toString());
            template = inputRecord.copy();
            AbstractParser.removeAttachments((Record)template);
            template.put("_attachment_mimetype", (Object)"avro/java+memory");
            reader = null;
            try {
                reader = new AvroParquetReader(this.conf, path);
                while (true) {
                    try {
                        datum = (IndexedRecord)reader.read();
                    }
                    catch (EOFException e) {
                        var9_12 = true;
                        Closeables.closeQuietly((Closeable)reader);
                        return var9_12;
                    }
                    break;
                }
            }
            catch (IOException e) {
                throw new MorphlineRuntimeException((Throwable)e);
            }
            catch (Throwable var10_13) {
                Closeables.closeQuietly(reader);
                throw var10_13;
            }
            {
                if (datum != null) ** GOTO lbl-1000
                var8_10 = true;
            }
            Closeables.closeQuietly((Closeable)reader);
            return var8_10;
lbl-1000:
            // 1 sources

            {
                if (this.extract((GenericContainer)datum, template)) ** continue;
                var8_11 = false;
            }
            Closeables.closeQuietly((Closeable)reader);
            return var8_11;
        }

        private boolean extract(GenericContainer datum, Record inputRecord) {
            this.incrementNumRecords();
            Record outputRecord = inputRecord.copy();
            outputRecord.put("_attachment_body", (Object)datum);
            return this.getChild().process(outputRecord);
        }

        private void incrementNumRecords() {
            if (this.isMeasuringMetrics()) {
                this.numRecordsMeter.mark();
            }
        }
    }
}

