/*
 * Decompiled with CFR 0.152.
 */
package org.kitesdk.morphline.maxmind;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.google.common.net.InetAddresses;
import com.maxmind.db.Reader;
import com.typesafe.config.Config;
import java.io.File;
import java.io.IOException;
import java.net.InetAddress;
import java.util.Collection;
import java.util.Collections;
import org.kitesdk.morphline.api.Command;
import org.kitesdk.morphline.api.CommandBuilder;
import org.kitesdk.morphline.api.MorphlineCompilationException;
import org.kitesdk.morphline.api.MorphlineContext;
import org.kitesdk.morphline.api.MorphlineRuntimeException;
import org.kitesdk.morphline.api.Record;
import org.kitesdk.morphline.base.AbstractCommand;
import org.kitesdk.morphline.base.Notifications;

public final class GeoIPBuilder
implements CommandBuilder {
    public Collection<String> getNames() {
        return Collections.singletonList("geoIP");
    }

    public Command build(Config config, Command parent, Command child, MorphlineContext context) {
        return new GeoIP(this, config, parent, child, context);
    }

    private static final class GeoIP
    extends AbstractCommand {
        private final String inputFieldName;
        private final File databaseFile;
        private final Reader databaseReader;

        public GeoIP(CommandBuilder builder, Config config, Command parent, Command child, MorphlineContext context) {
            super(builder, config, parent, child, context);
            this.inputFieldName = this.getConfigs().getString(config, "inputField");
            this.databaseFile = new File(this.getConfigs().getString(config, "database", "GeoLite2-City.mmdb"));
            try {
                this.databaseReader = new Reader(this.databaseFile);
            }
            catch (IOException e) {
                throw new MorphlineCompilationException("Cannot read Maxmind database: " + this.databaseFile, config, (Throwable)e);
            }
            this.validateArguments();
        }

        protected boolean doProcess(Record record) {
            for (Object value : record.get(this.inputFieldName)) {
                JsonNode json;
                InetAddress addr;
                if (value instanceof InetAddress) {
                    addr = (InetAddress)value;
                } else {
                    try {
                        addr = InetAddresses.forString((String)value.toString());
                    }
                    catch (IllegalArgumentException e) {
                        this.LOG.debug("Invalid IP string literal: {}", value);
                        return false;
                    }
                }
                try {
                    json = this.databaseReader.get(addr);
                }
                catch (IOException e) {
                    throw new MorphlineRuntimeException("Cannot perform GeoIP lookup for IP: " + addr, (Throwable)e);
                }
                ObjectNode location = (ObjectNode)json.get("location");
                if (location != null) {
                    JsonNode jlatitude = location.get("latitude");
                    JsonNode jlongitude = location.get("longitude");
                    if (jlatitude != null && jlongitude != null) {
                        String latitude = jlatitude.toString();
                        String longitude = jlongitude.toString();
                        location.put("latitude_longitude", latitude + "," + longitude);
                        location.put("longitude_latitude", longitude + "," + latitude);
                    }
                }
                record.put("_attachment_body", (Object)json);
            }
            return super.doProcess(record);
        }

        protected void doNotify(Record notification) {
            for (Object event : Notifications.getLifecycleEvents((Record)notification)) {
                if (event != Notifications.LifecycleEvent.SHUTDOWN) continue;
                try {
                    this.databaseReader.close();
                }
                catch (IOException e) {
                    this.LOG.warn("Cannot close Maxmind database: " + this.databaseFile, (Throwable)e);
                }
            }
            super.doNotify(notification);
        }
    }
}

