/*
 * Decompiled with CFR 0.152.
 */
package org.kitesdk.morphline.solr;

import com.google.common.base.Preconditions;
import com.typesafe.config.Config;
import com.typesafe.config.ConfigFactory;
import com.typesafe.config.ConfigRenderOptions;
import com.typesafe.config.ConfigUtil;
import java.net.MalformedURLException;
import org.apache.solr.client.solrj.SolrServer;
import org.apache.solr.client.solrj.embedded.EmbeddedSolrServer;
import org.apache.solr.client.solrj.impl.CloudSolrServer;
import org.apache.solr.core.CoreContainer;
import org.apache.solr.schema.IndexSchema;
import org.kitesdk.morphline.api.MorphlineCompilationException;
import org.kitesdk.morphline.api.MorphlineContext;
import org.kitesdk.morphline.api.MorphlineRuntimeException;
import org.kitesdk.morphline.base.Configs;
import org.kitesdk.morphline.solr.DocumentLoader;
import org.kitesdk.morphline.solr.SafeConcurrentUpdateSolrServer;
import org.kitesdk.morphline.solr.SolrMorphlineContext;
import org.kitesdk.morphline.solr.SolrServerDocumentLoader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SolrLocator {
    private Config config;
    private MorphlineContext context;
    private String collectionName;
    private String zkHost;
    private String solrUrl;
    private String solrHomeDir;
    private int batchSize = 1000;
    private static final Logger LOG = LoggerFactory.getLogger(SolrLocator.class);

    protected SolrLocator(MorphlineContext context) {
        Preconditions.checkNotNull((Object)context);
        this.context = context;
    }

    public SolrLocator(Config config, MorphlineContext context) {
        this(context);
        this.config = config;
        Configs configs = new Configs();
        this.collectionName = configs.getString(config, "collection", null);
        this.zkHost = configs.getString(config, "zkHost", null);
        this.solrHomeDir = configs.getString(config, "solrHomeDir", null);
        this.solrUrl = configs.getString(config, "solrUrl", null);
        this.batchSize = configs.getInt(config, "batchSize", this.batchSize);
        LOG.trace("Constructed solrLocator: {}", (Object)this);
        configs.validateArguments(config);
    }

    public DocumentLoader getLoader() {
        int solrServerNumThreads;
        DocumentLoader loader;
        if (this.context instanceof SolrMorphlineContext && (loader = ((SolrMorphlineContext)this.context).getDocumentLoader()) != null) {
            return loader;
        }
        if (this.zkHost != null && this.zkHost.length() > 0) {
            if (this.collectionName == null || this.collectionName.length() == 0) {
                throw new MorphlineCompilationException("Parameter 'zkHost' requires that you also pass parameter 'collection'", this.config);
            }
            try {
                CloudSolrServer cloudSolrServer = new CloudSolrServer(this.zkHost);
                cloudSolrServer.setDefaultCollection(this.collectionName);
                cloudSolrServer.connect();
                return new SolrServerDocumentLoader((SolrServer)cloudSolrServer, this.batchSize);
            }
            catch (MalformedURLException e) {
                throw new MorphlineRuntimeException((Throwable)e);
            }
        }
        if (this.solrUrl == null && this.solrHomeDir != null) {
            CoreContainer coreContainer = new CoreContainer(this.solrHomeDir);
            coreContainer.load();
            EmbeddedSolrServer embeddedSolrServer = new EmbeddedSolrServer(coreContainer, this.collectionName);
            return new SolrServerDocumentLoader((SolrServer)embeddedSolrServer, this.batchSize);
        }
        if (this.solrUrl == null || this.solrUrl.length() == 0) {
            throw new MorphlineCompilationException("Missing parameter 'solrUrl'", this.config);
        }
        int solrServerQueueLength = solrServerNumThreads = 2;
        SafeConcurrentUpdateSolrServer server = new SafeConcurrentUpdateSolrServer(this.solrUrl, solrServerQueueLength, solrServerNumThreads);
        return new SolrServerDocumentLoader((SolrServer)server, this.batchSize);
    }

    /*
     * Exception decompiling
     */
    public IndexSchema getIndexSchema() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [12[CATCHBLOCK]], but top level block is 5[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void validateSchema(IndexSchema schema) {
        if (schema.getUniqueKeyField() == null) {
            throw new MorphlineCompilationException("Solr schema.xml is missing unique key field", this.config);
        }
        if (!schema.getUniqueKeyField().isRequired()) {
            throw new MorphlineCompilationException("Solr schema.xml must contain a required unique key field", this.config);
        }
    }

    public String toString() {
        return this.toConfig(null).root().render(ConfigRenderOptions.concise());
    }

    public Config toConfig(String key) {
        String json = "";
        if (key != null) {
            json = this.toJson(key) + " : ";
        }
        json = json + "{ collection : " + this.toJson(this.collectionName) + ", " + " zkHost : " + this.toJson(this.zkHost) + ", " + " solrUrl : " + this.toJson(this.solrUrl) + ", " + " solrHomeDir : " + this.toJson(this.solrHomeDir) + ", " + " batchSize : " + this.toJson(this.batchSize) + " " + "}";
        return ConfigFactory.parseString((String)json);
    }

    private String toJson(Object key) {
        String str = key == null ? "" : key.toString();
        str = ConfigUtil.quoteString((String)str);
        return str;
    }

    public String getCollectionName() {
        return this.collectionName;
    }

    public void setCollectionName(String collectionName) {
        this.collectionName = collectionName;
    }

    public String getZkHost() {
        return this.zkHost;
    }

    public void setZkHost(String zkHost) {
        this.zkHost = zkHost;
    }

    public String getSolrHomeDir() {
        return this.solrHomeDir;
    }

    public void setSolrHomeDir(String solrHomeDir) {
        this.solrHomeDir = solrHomeDir;
    }

    public String getServerUrl() {
        return this.solrUrl;
    }

    public void setServerUrl(String solrUrl) {
        this.solrUrl = solrUrl;
    }

    public int getBatchSize() {
        return this.batchSize;
    }

    public void setBatchSize(int batchSize) {
        this.batchSize = batchSize;
    }
}

