/*
 * Decompiled with CFR 0.152.
 */
package org.kitesdk.morphline.solr;

import com.codahale.metrics.MetricRegistry;
import com.google.common.base.Joiner;
import com.google.common.io.Files;
import com.typesafe.config.Config;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.solr.SolrTestCaseJ4;
import org.apache.solr.client.solrj.ResponseParser;
import org.apache.solr.client.solrj.SolrQuery;
import org.apache.solr.client.solrj.SolrServer;
import org.apache.solr.client.solrj.SolrServerException;
import org.apache.solr.client.solrj.impl.HttpSolrServer;
import org.apache.solr.client.solrj.impl.XMLResponseParser;
import org.apache.solr.client.solrj.response.QueryResponse;
import org.apache.solr.common.SolrDocument;
import org.apache.solr.common.params.SolrParams;
import org.junit.After;
import org.junit.Before;
import org.junit.BeforeClass;
import org.kitesdk.morphline.api.Collector;
import org.kitesdk.morphline.api.Command;
import org.kitesdk.morphline.api.ExceptionHandler;
import org.kitesdk.morphline.api.MorphlineContext;
import org.kitesdk.morphline.api.Record;
import org.kitesdk.morphline.base.Compiler;
import org.kitesdk.morphline.base.FaultTolerance;
import org.kitesdk.morphline.base.Notifications;
import org.kitesdk.morphline.solr.DocumentLoader;
import org.kitesdk.morphline.solr.SolrLocator;
import org.kitesdk.morphline.solr.SolrMorphlineContext;
import org.kitesdk.morphline.solr.SolrServerDocumentLoader;
import org.kitesdk.morphline.solr.TestEmbeddedSolrServer;
import org.kitesdk.morphline.stdlib.PipeBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AbstractSolrMorphlineTest
extends SolrTestCaseJ4 {
    protected Collector collector;
    protected Command morphline;
    protected SolrServer solrServer;
    protected DocumentLoader testServer;
    protected static final boolean TEST_WITH_EMBEDDED_SOLR_SERVER = true;
    protected static final String EXTERNAL_SOLR_SERVER_URL = System.getProperty("externalSolrServer");
    protected static final String RESOURCES_DIR = "target" + File.separator + "test-classes";
    protected static final String DEFAULT_BASE_DIR = "solr";
    protected static final AtomicInteger SEQ_NUM = new AtomicInteger();
    protected static final AtomicInteger SEQ_NUM2 = new AtomicInteger();
    protected static final Object NON_EMPTY_FIELD = new Object();
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractSolrMorphlineTest.class);

    @BeforeClass
    public static void beforeClass() throws Exception {
        AbstractSolrMorphlineTest.assumeFalse((String)"This test fails on UNIX with Turkish default locale (https://issues.apache.org/jira/browse/SOLR-6387)", (boolean)new Locale("tr").getLanguage().equals(Locale.getDefault().getLanguage()));
        AbstractSolrMorphlineTest.myInitCore(DEFAULT_BASE_DIR);
    }

    protected static void myInitCore(String baseDirName) throws Exception {
        Joiner joiner = Joiner.on((String)File.separator);
        AbstractSolrMorphlineTest.initCore((String)"solrconfig.xml", (String)"schema.xml", (String)joiner.join((Object)RESOURCES_DIR, (Object)baseDirName, new Object[0]));
    }

    @Before
    public void setUp() throws Exception {
        super.setUp();
        this.collector = new Collector();
        if (EXTERNAL_SOLR_SERVER_URL != null) {
            this.solrServer = new HttpSolrServer(EXTERNAL_SOLR_SERVER_URL);
            ((HttpSolrServer)this.solrServer).setParser((ResponseParser)new XMLResponseParser());
        } else {
            this.solrServer = new TestEmbeddedSolrServer(h.getCoreContainer(), "");
        }
        int batchSize = SEQ_NUM2.incrementAndGet() % 2 == 0 ? 100 : 1;
        this.testServer = new SolrServerDocumentLoader(this.solrServer, batchSize);
        this.deleteAllDocuments();
    }

    @After
    public void tearDown() throws Exception {
        this.collector = null;
        this.solrServer.shutdown();
        this.solrServer = null;
        super.tearDown();
    }

    protected void testDocumentTypesInternal(String[] files, Map<String, Integer> expectedRecords, Map<String, Map<String, Object>> expectedRecordContents) throws Exception {
        AbstractSolrMorphlineTest.assumeTrue((String)"This test has issues with this locale: https://issues.apache.org/jira/browse/SOLR-5778", (boolean)"GregorianCalendar".equals(Calendar.getInstance(TimeZone.getDefault(), Locale.getDefault()).getClass().getSimpleName()));
        this.deleteAllDocuments();
        int numDocs = 0;
        for (int i = 0; i < 1; ++i) {
            for (String file : files) {
                File f = new File(file);
                byte[] body = Files.toByteArray((File)f);
                Record event = new Record();
                event.getFields().put((Object)"_attachment_body", (Object)new ByteArrayInputStream(body));
                event.getFields().put((Object)"_attachment_name", (Object)f.getName());
                event.getFields().put((Object)"base_id", (Object)f.getName());
                this.collector.reset();
                this.load(event);
                Integer count = expectedRecords.get(file);
                numDocs = count != null ? (numDocs += count.intValue()) : ++numDocs;
                AbstractSolrMorphlineTest.assertEquals((String)("unexpected results in " + file), (long)numDocs, (long)this.queryResultSetSize("*:*"));
                Map<String, Object> expectedContents = expectedRecordContents.get(file);
                if (expectedContents == null) continue;
                Record actual = this.collector.getFirstRecord();
                for (Map.Entry<String, Object> entry : expectedContents.entrySet()) {
                    if (entry.getValue() == NON_EMPTY_FIELD) {
                        AbstractSolrMorphlineTest.assertNotNull((Object)entry.getKey());
                        AbstractSolrMorphlineTest.assertTrue((actual.getFirstValue(entry.getKey()).toString().length() > 0 ? 1 : 0) != 0);
                        continue;
                    }
                    if (entry.getValue() == null) {
                        AbstractSolrMorphlineTest.assertEquals((String)("key:" + entry.getKey()), (long)0L, (long)actual.get(entry.getKey()).size());
                        continue;
                    }
                    AbstractSolrMorphlineTest.assertEquals((String)("key:" + entry.getKey()), Arrays.asList(entry.getValue()), (Object)actual.get(entry.getKey()));
                }
            }
        }
        AbstractSolrMorphlineTest.assertEquals((long)numDocs, (long)this.queryResultSetSize("*:*"));
    }

    private boolean load(Record record) {
        Notifications.notifyStartSession((Command)this.morphline);
        return this.morphline.process(record);
    }

    protected QueryResponse query(String query) {
        try {
            this.testServer.commitTransaction();
            this.solrServer.commit(false, true, true);
            QueryResponse rsp = this.solrServer.query((SolrParams)new SolrQuery(query).setRows(Integer.valueOf(Integer.MAX_VALUE)).setSort("id", SolrQuery.ORDER.asc));
            return rsp;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    protected int queryResultSetSize(String query) {
        try {
            QueryResponse rsp = this.query(query);
            LOGGER.debug("rsp: {}", (Object)rsp);
            int i = 0;
            for (SolrDocument doc : rsp.getResults()) {
                LOGGER.debug("rspDoc #{}: {}", (Object)i++, (Object)doc);
            }
            int size = rsp.getResults().size();
            return size;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private void deleteAllDocuments() throws SolrServerException, IOException {
        this.collector.reset();
        SolrServer s = this.solrServer;
        s.deleteByQuery("*:*");
        s.commit();
    }

    protected Command createMorphline(String file) throws IOException {
        return new PipeBuilder().build(this.parse(file), null, (Command)this.collector, this.createMorphlineContext());
    }

    private MorphlineContext createMorphlineContext() {
        return new SolrMorphlineContext.Builder().setDocumentLoader(this.testServer).setExceptionHandler((ExceptionHandler)new FaultTolerance(false, false, SolrServerException.class.getName())).setMetricRegistry(new MetricRegistry()).build();
    }

    private Config parse(String file) throws IOException {
        SolrLocator locator = new SolrLocator(this.createMorphlineContext());
        locator.setSolrHomeDir(testSolrHome + File.separator + "collection1");
        Config config = new Compiler().parse(new File(RESOURCES_DIR + File.separator + file + ".conf"), new Config[]{locator.toConfig("SOLR_LOCATOR")});
        config = (Config)config.getConfigList("morphlines").get(0);
        return config;
    }

    protected void startSession() {
        Notifications.notifyStartSession((Command)this.morphline);
    }

    protected void testDocumentContent(HashMap<String, ExpectedResult> expectedResultMap) throws Exception {
        QueryResponse rsp = this.solrServer.query((SolrParams)new SolrQuery("*:*").setRows(Integer.valueOf(Integer.MAX_VALUE)));
        for (Map.Entry<String, ExpectedResult> current : expectedResultMap.entrySet()) {
            String field = current.getKey();
            for (String expectedFieldValue : current.getValue().getFieldValues()) {
                ExpectedResult.CompareType compareType = current.getValue().getCompareType();
                boolean foundField = false;
                block2: for (SolrDocument doc : rsp.getResults()) {
                    Collection actualFieldValues = doc.getFieldValues(field);
                    if (compareType == ExpectedResult.CompareType.equals) {
                        if (actualFieldValues == null || !actualFieldValues.contains(expectedFieldValue)) continue;
                        foundField = true;
                        break;
                    }
                    Iterator it = actualFieldValues.iterator();
                    while (it.hasNext()) {
                        String actualValue = it.next().toString();
                        if (actualFieldValues == null || !actualValue.contains(expectedFieldValue)) continue;
                        foundField = true;
                        continue block2;
                    }
                }
                assert (foundField);
            }
        }
    }

    protected static class ExpectedResult {
        private HashSet<String> fieldValues;
        private CompareType compareType;

        public ExpectedResult(HashSet<String> fieldValues, CompareType compareType) {
            this.fieldValues = fieldValues;
            this.compareType = compareType;
        }

        public HashSet<String> getFieldValues() {
            return this.fieldValues;
        }

        public CompareType getCompareType() {
            return this.compareType;
        }

        public static enum CompareType {
            equals,
            contains;

        }
    }
}

