/*
 * Decompiled with CFR 0.152.
 */
package org.kitesdk.morphline.solr;

import com.codahale.metrics.MetricRegistry;
import com.google.common.collect.ListMultimap;
import com.typesafe.config.Config;
import java.io.File;
import java.io.IOException;
import java.util.Iterator;
import java.util.Locale;
import org.apache.solr.SolrTestCaseJ4;
import org.apache.solr.client.solrj.SolrServerException;
import org.apache.solr.client.solrj.embedded.JettySolrRunner;
import org.apache.solr.client.solrj.embedded.SSLConfig;
import org.apache.solr.cloud.AbstractFullDistribZkTestBase;
import org.apache.solr.common.SolrDocument;
import org.apache.solr.common.cloud.SolrZkClient;
import org.junit.After;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.kitesdk.morphline.api.Collector;
import org.kitesdk.morphline.api.Command;
import org.kitesdk.morphline.api.ExceptionHandler;
import org.kitesdk.morphline.api.MorphlineContext;
import org.kitesdk.morphline.api.Record;
import org.kitesdk.morphline.base.Compiler;
import org.kitesdk.morphline.base.FaultTolerance;
import org.kitesdk.morphline.base.Notifications;
import org.kitesdk.morphline.solr.SolrLocator;
import org.kitesdk.morphline.stdlib.PipeBuilder;

@SolrTestCaseJ4.SuppressSSL
public abstract class AbstractSolrMorphlineZkTest
extends AbstractFullDistribZkTestBase {
    protected static final String RESOURCES_DIR = "target/test-classes";
    private static final File SOLR_INSTANCE_DIR = new File("target/test-classes/solr");
    private static final File SOLR_CONF_DIR = new File("target/test-classes/solr/collection1");
    protected Collector collector;
    protected Command morphline;

    public String getSolrHome() {
        return SOLR_INSTANCE_DIR.getPath();
    }

    public AbstractSolrMorphlineZkTest() {
        this.fixShardCount = true;
        this.sliceCount = 3;
        this.shardCount = 3;
    }

    @BeforeClass
    public static void setupClass() throws Exception {
        AbstractSolrMorphlineZkTest.assumeFalse((String)"This test fails on UNIX with Turkish default locale (https://issues.apache.org/jira/browse/SOLR-6387)", (boolean)new Locale("tr").getLanguage().equals(Locale.getDefault().getLanguage()));
        AbstractSolrMorphlineZkTest.createTempDir();
    }

    @Before
    public void setUp() throws Exception {
        super.setUp();
        System.setProperty("host", "127.0.0.1");
        System.setProperty("numShards", Integer.toString(this.sliceCount));
        this.uploadConfFiles();
        this.collector = new Collector();
    }

    @After
    public void tearDown() throws Exception {
        super.tearDown();
        System.clearProperty("host");
        System.clearProperty("numShards");
    }

    @Test
    public void testDistribSearch() throws Exception {
        super.testDistribSearch();
    }

    protected void commit() throws Exception {
        Notifications.notifyCommitTransaction((Command)this.morphline);
        super.commit();
    }

    protected Command parse(String file) throws IOException {
        return this.parse(file, "collection1");
    }

    protected Command parse(String file, String collection) throws IOException {
        SolrLocator locator = new SolrLocator(this.createMorphlineContext());
        locator.setCollectionName(collection);
        locator.setZkHost(this.zkServer.getZkAddress());
        Config config = new Compiler().parse(new File("target/test-classes/" + file + ".conf"), new Config[]{locator.toConfig("SOLR_LOCATOR")});
        config = (Config)config.getConfigList("morphlines").get(0);
        return this.createMorphline(config);
    }

    private Command createMorphline(Config config) {
        return new PipeBuilder().build(config, null, (Command)this.collector, this.createMorphlineContext());
    }

    private MorphlineContext createMorphlineContext() {
        return new MorphlineContext.Builder().setExceptionHandler((ExceptionHandler)new FaultTolerance(false, false, SolrServerException.class.getName())).setMetricRegistry(new MetricRegistry()).build();
    }

    protected void startSession() {
        Notifications.notifyStartSession((Command)this.morphline);
    }

    protected ListMultimap<String, Object> next(Iterator<SolrDocument> iter) {
        SolrDocument doc = iter.next();
        Record record = this.toRecord(doc);
        record.removeAll("_version_");
        return record.getFields();
    }

    private Record toRecord(SolrDocument doc) {
        Record record = new Record();
        for (String key : doc.keySet()) {
            record.getFields().replaceValues((Object)key, (Iterable)doc.getFieldValues(key));
        }
        return record;
    }

    public JettySolrRunner createJetty(File solrHome, String dataDir, String shardList, String solrConfigOverride, String schemaOverride) throws Exception {
        JettySolrRunner jetty = new JettySolrRunner(solrHome.getAbsolutePath(), this.context, 0, solrConfigOverride, schemaOverride, true, null, (SSLConfig)sslConfig);
        jetty.setShards(shardList);
        if (System.getProperty("collection") == null) {
            System.setProperty("collection", "collection1");
        }
        jetty.start();
        System.clearProperty("collection");
        return jetty;
    }

    private static void putConfig(SolrZkClient zkClient, File solrhome, String name) throws Exception {
        AbstractSolrMorphlineZkTest.putConfig(zkClient, solrhome, name, name);
    }

    private static void putConfig(SolrZkClient zkClient, File solrhome, String srcName, String destName) throws Exception {
        File file = new File(solrhome, "conf" + File.separator + srcName);
        if (!file.exists()) {
            return;
        }
        String destPath = "/configs/conf1/" + destName;
        zkClient.makePath(destPath, file, false, true);
    }

    private void uploadConfFiles() throws Exception {
        SolrZkClient zkClient = new SolrZkClient(this.zkServer.getZkAddress(), 10000);
        AbstractSolrMorphlineZkTest.putConfig(zkClient, SOLR_CONF_DIR, "solrconfig.xml");
        AbstractSolrMorphlineZkTest.putConfig(zkClient, SOLR_CONF_DIR, "schema.xml");
        AbstractSolrMorphlineZkTest.putConfig(zkClient, SOLR_CONF_DIR, "elevate.xml");
        AbstractSolrMorphlineZkTest.putConfig(zkClient, SOLR_CONF_DIR, "lang/stopwords_en.txt");
        AbstractSolrMorphlineZkTest.putConfig(zkClient, SOLR_CONF_DIR, "lang/stopwords_ar.txt");
        AbstractSolrMorphlineZkTest.putConfig(zkClient, SOLR_CONF_DIR, "lang/stopwords_bg.txt");
        AbstractSolrMorphlineZkTest.putConfig(zkClient, SOLR_CONF_DIR, "lang/stopwords_ca.txt");
        AbstractSolrMorphlineZkTest.putConfig(zkClient, SOLR_CONF_DIR, "lang/stopwords_cz.txt");
        AbstractSolrMorphlineZkTest.putConfig(zkClient, SOLR_CONF_DIR, "lang/stopwords_da.txt");
        AbstractSolrMorphlineZkTest.putConfig(zkClient, SOLR_CONF_DIR, "lang/stopwords_el.txt");
        AbstractSolrMorphlineZkTest.putConfig(zkClient, SOLR_CONF_DIR, "lang/stopwords_es.txt");
        AbstractSolrMorphlineZkTest.putConfig(zkClient, SOLR_CONF_DIR, "lang/stopwords_eu.txt");
        AbstractSolrMorphlineZkTest.putConfig(zkClient, SOLR_CONF_DIR, "lang/stopwords_de.txt");
        AbstractSolrMorphlineZkTest.putConfig(zkClient, SOLR_CONF_DIR, "lang/stopwords_fa.txt");
        AbstractSolrMorphlineZkTest.putConfig(zkClient, SOLR_CONF_DIR, "lang/stopwords_fi.txt");
        AbstractSolrMorphlineZkTest.putConfig(zkClient, SOLR_CONF_DIR, "lang/stopwords_fr.txt");
        AbstractSolrMorphlineZkTest.putConfig(zkClient, SOLR_CONF_DIR, "lang/stopwords_ga.txt");
        AbstractSolrMorphlineZkTest.putConfig(zkClient, SOLR_CONF_DIR, "lang/stopwords_gl.txt");
        AbstractSolrMorphlineZkTest.putConfig(zkClient, SOLR_CONF_DIR, "lang/stopwords_hi.txt");
        AbstractSolrMorphlineZkTest.putConfig(zkClient, SOLR_CONF_DIR, "lang/stopwords_hu.txt");
        AbstractSolrMorphlineZkTest.putConfig(zkClient, SOLR_CONF_DIR, "lang/stopwords_hy.txt");
        AbstractSolrMorphlineZkTest.putConfig(zkClient, SOLR_CONF_DIR, "lang/stopwords_id.txt");
        AbstractSolrMorphlineZkTest.putConfig(zkClient, SOLR_CONF_DIR, "lang/stopwords_it.txt");
        AbstractSolrMorphlineZkTest.putConfig(zkClient, SOLR_CONF_DIR, "lang/stopwords_ja.txt");
        AbstractSolrMorphlineZkTest.putConfig(zkClient, SOLR_CONF_DIR, "lang/stopwords_lv.txt");
        AbstractSolrMorphlineZkTest.putConfig(zkClient, SOLR_CONF_DIR, "lang/stopwords_nl.txt");
        AbstractSolrMorphlineZkTest.putConfig(zkClient, SOLR_CONF_DIR, "lang/stopwords_no.txt");
        AbstractSolrMorphlineZkTest.putConfig(zkClient, SOLR_CONF_DIR, "lang/stopwords_pt.txt");
        AbstractSolrMorphlineZkTest.putConfig(zkClient, SOLR_CONF_DIR, "lang/stopwords_ro.txt");
        AbstractSolrMorphlineZkTest.putConfig(zkClient, SOLR_CONF_DIR, "lang/stopwords_ru.txt");
        AbstractSolrMorphlineZkTest.putConfig(zkClient, SOLR_CONF_DIR, "lang/stopwords_sv.txt");
        AbstractSolrMorphlineZkTest.putConfig(zkClient, SOLR_CONF_DIR, "lang/stopwords_th.txt");
        AbstractSolrMorphlineZkTest.putConfig(zkClient, SOLR_CONF_DIR, "lang/stopwords_tr.txt");
        AbstractSolrMorphlineZkTest.putConfig(zkClient, SOLR_CONF_DIR, "lang/contractions_ca.txt");
        AbstractSolrMorphlineZkTest.putConfig(zkClient, SOLR_CONF_DIR, "lang/contractions_fr.txt");
        AbstractSolrMorphlineZkTest.putConfig(zkClient, SOLR_CONF_DIR, "lang/contractions_ga.txt");
        AbstractSolrMorphlineZkTest.putConfig(zkClient, SOLR_CONF_DIR, "lang/contractions_it.txt");
        AbstractSolrMorphlineZkTest.putConfig(zkClient, SOLR_CONF_DIR, "lang/stemdict_nl.txt");
        AbstractSolrMorphlineZkTest.putConfig(zkClient, SOLR_CONF_DIR, "lang/hyphenations_ga.txt");
        AbstractSolrMorphlineZkTest.putConfig(zkClient, SOLR_CONF_DIR, "stopwords.txt");
        AbstractSolrMorphlineZkTest.putConfig(zkClient, SOLR_CONF_DIR, "protwords.txt");
        AbstractSolrMorphlineZkTest.putConfig(zkClient, SOLR_CONF_DIR, "currency.xml");
        AbstractSolrMorphlineZkTest.putConfig(zkClient, SOLR_CONF_DIR, "open-exchange-rates.json");
        AbstractSolrMorphlineZkTest.putConfig(zkClient, SOLR_CONF_DIR, "mapping-ISOLatin1Accent.txt");
        AbstractSolrMorphlineZkTest.putConfig(zkClient, SOLR_CONF_DIR, "old_synonyms.txt");
        AbstractSolrMorphlineZkTest.putConfig(zkClient, SOLR_CONF_DIR, "synonyms.txt");
        zkClient.close();
    }
}

