/*
 * Decompiled with CFR 0.152.
 */
package org.kitesdk.morphline.solr;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.solr.client.solrj.SolrServerException;
import org.apache.solr.client.solrj.response.SolrPingResponse;
import org.apache.solr.client.solrj.response.UpdateResponse;
import org.apache.solr.common.SolrInputDocument;
import org.kitesdk.morphline.solr.DocumentLoader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class CollectingDocumentLoader
implements DocumentLoader {
    private final int batchSize;
    private final List<SolrInputDocument> batch = new ArrayList<SolrInputDocument>();
    private List<SolrInputDocument> results = new ArrayList<SolrInputDocument>();
    private static final Logger LOGGER = LoggerFactory.getLogger(CollectingDocumentLoader.class);

    public CollectingDocumentLoader(int batchSize) {
        if (batchSize <= 0) {
            throw new IllegalArgumentException("batchSize must be a positive number: " + batchSize);
        }
        this.batchSize = batchSize;
    }

    public void beginTransaction() {
        LOGGER.trace("beginTransaction");
        this.batch.clear();
    }

    public void load(SolrInputDocument doc) {
        LOGGER.trace("load doc: {}", (Object)doc);
        this.batch.add(doc);
        if (this.batch.size() >= this.batchSize) {
            this.loadBatch();
        }
    }

    public void deleteById(String id) throws IOException, SolrServerException {
        throw new UnsupportedOperationException();
    }

    public void deleteByQuery(String id) throws IOException, SolrServerException {
        throw new UnsupportedOperationException();
    }

    public void commitTransaction() {
        LOGGER.trace("commitTransaction");
        if (this.batch.size() > 0) {
            this.loadBatch();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadBatch() {
        try {
            this.results.addAll(this.batch);
        }
        finally {
            this.batch.clear();
        }
    }

    public UpdateResponse rollbackTransaction() {
        LOGGER.trace("rollback");
        return new UpdateResponse();
    }

    public void shutdown() {
        LOGGER.trace("shutdown");
    }

    public SolrPingResponse ping() {
        LOGGER.trace("ping");
        return new SolrPingResponse();
    }
}

