/*
 * Decompiled with CFR 0.152.
 */
package org.kitesdk.morphline.solr;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.text.ParseException;
import org.apache.commons.lang.SystemUtils;
import org.apache.lucene.LucenePackage;
import org.apache.lucene.util.Version;
import org.apache.solr.core.SolrCore;
import org.junit.Assert;
import org.junit.Test;

public class EnvironmentTest
extends Assert {
    private static final String EXPECTED_SOLR_VERSION;

    @Test
    public void testEnvironment() throws UnknownHostException {
        System.out.println("EXPECTED_SOLR_VERSION: " + EXPECTED_SOLR_VERSION);
        System.out.println("Running test suite with java version: " + SystemUtils.JAVA_VERSION + " " + SystemUtils.JAVA_VM_NAME + " on " + SystemUtils.OS_NAME + " " + SystemUtils.OS_VERSION + "/" + SystemUtils.OS_ARCH + " on host: " + InetAddress.getLocalHost().getHostName());
        Package p = SolrCore.class.getPackage();
        System.out.println("Running test suite with solr-spec-version: " + p.getSpecificationVersion() + ", solr-impl-version: " + p.getImplementationVersion());
        if (EXPECTED_SOLR_VERSION != null) {
            EnvironmentTest.assertTrue((String)("unexpected version: " + p.getSpecificationVersion()), (boolean)p.getSpecificationVersion().startsWith(EXPECTED_SOLR_VERSION));
            EnvironmentTest.assertTrue((String)("unexpected version: " + p.getImplementationVersion()), (boolean)p.getImplementationVersion().startsWith(EXPECTED_SOLR_VERSION));
        }
        p = LucenePackage.class.getPackage();
        System.out.println("Running test suite with lucene-spec-version: " + p.getSpecificationVersion() + ", lucene-impl-version: " + p.getImplementationVersion());
        if (EXPECTED_SOLR_VERSION != null) {
            EnvironmentTest.assertTrue((String)("unexpected version: " + p.getSpecificationVersion()), (boolean)p.getSpecificationVersion().startsWith(EXPECTED_SOLR_VERSION));
            EnvironmentTest.assertTrue((String)("unexpected version: " + p.getImplementationVersion()), (boolean)p.getImplementationVersion().startsWith(EXPECTED_SOLR_VERSION));
            Version expectedMinorLuceneVersion = EnvironmentTest.getMinorLuceneVersion(EXPECTED_SOLR_VERSION);
            System.out.println("expectedMinorLuceneVersion: " + expectedMinorLuceneVersion);
            EnvironmentTest.assertTrue((boolean)Version.LATEST.onOrAfter(expectedMinorLuceneVersion));
        }
    }

    private static Version getMinorLuceneVersion(String version) {
        try {
            return Version.parseLeniently((String)version.replaceFirst("^(\\d)\\.(\\d).*", "LUCENE_$1$2"));
        }
        catch (ParseException e) {
            throw new RuntimeException(e);
        }
    }

    static {
        int i;
        String version = System.getProperty("solr.expected.version");
        if (version != null && (i = version.indexOf(45)) >= 0) {
            version = version.substring(0, i);
        }
        EXPECTED_SOLR_VERSION = version;
    }
}

