/*
 * Decompiled with CFR 0.152.
 */
package org.kitesdk.morphline.solr;

import com.google.common.collect.ImmutableMap;
import com.google.common.io.Files;
import java.io.File;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import org.apache.commons.io.FileUtils;
import org.apache.solr.common.SolrDocument;
import org.apache.solr.common.SolrDocumentList;
import org.apache.solr.schema.IndexSchema;
import org.junit.Test;
import org.kitesdk.morphline.api.Command;
import org.kitesdk.morphline.api.MorphlineContext;
import org.kitesdk.morphline.api.Record;
import org.kitesdk.morphline.base.Notifications;
import org.kitesdk.morphline.solr.AbstractSolrMorphlineTest;
import org.kitesdk.morphline.solr.SolrLocator;

public class SolrMorphlineTest
extends AbstractSolrMorphlineTest {
    private static final File SOLR_INSTANCE_DIR = new File(RESOURCES_DIR + "/solr");

    @Test
    public void testLoadSchema() throws Exception {
        SolrLocator locator = new SolrLocator(new MorphlineContext.Builder().build());
        locator.setCollectionName("collection1");
        locator.setSolrHomeDir("solr" + File.separator + "collection1");
        SolrMorphlineTest.assertNotNull((Object)locator.getIndexSchema());
    }

    @Test
    public void testLoadManagedSchema() throws Exception {
        File solrHomeDir = Files.createTempDir();
        solrHomeDir.deleteOnExit();
        File collection1Dir = new File(SOLR_INSTANCE_DIR, "collection1");
        FileUtils.copyDirectory((File)collection1Dir, (File)solrHomeDir);
        File managedCollectionDir = new File(SOLR_INSTANCE_DIR, "managedSchemaCollection");
        FileUtils.copyDirectory((File)managedCollectionDir, (File)solrHomeDir);
        File oldSchemaXml = new File(solrHomeDir + File.separator + "conf" + File.separator + "schema.xml");
        oldSchemaXml.delete();
        SolrMorphlineTest.assertFalse((boolean)oldSchemaXml.exists());
        SolrLocator locator = new SolrLocator(new MorphlineContext.Builder().build());
        locator.setCollectionName("managedSchemaCollection");
        locator.setSolrHomeDir(solrHomeDir.getAbsolutePath());
        IndexSchema schema = locator.getIndexSchema();
        SolrMorphlineTest.assertNotNull((Object)schema);
        schema.getField("test-managed-morphline-field");
    }

    @Test
    public void testLoadSolrBasic() throws Exception {
        this.morphline = this.createMorphline("test-morphlines" + File.separator + "loadSolrBasic");
        Record record = new Record();
        record.put("id", (Object)"id0");
        record.put("first_name", (Object)"Nadja");
        this.startSession();
        Notifications.notifyBeginTransaction((Command)this.morphline);
        SolrMorphlineTest.assertTrue((boolean)this.morphline.process(record));
        SolrMorphlineTest.assertEquals((long)1L, (long)this.collector.getNumStartEvents());
        Notifications.notifyCommitTransaction((Command)this.morphline);
        Record expected = new Record();
        expected.put("id", (Object)"id0");
        SolrMorphlineTest.assertEquals(Arrays.asList(expected), (Object)this.collector.getRecords());
        SolrMorphlineTest.assertEquals((long)1L, (long)this.queryResultSetSize("*:*"));
        Notifications.notifyRollbackTransaction((Command)this.morphline);
        Notifications.notifyShutdown((Command)this.morphline);
    }

    public void testLoadSolrWithPartialUpdate() throws Exception {
        this.morphline = this.createMorphline("test-morphlines" + File.separator + "loadSolrBasic");
        Record record = new Record();
        record.put("id", (Object)"id0");
        record.put("user_friends_count", (Object)123);
        record.put("text", (Object)"myText");
        Notifications.notifyBeginTransaction((Command)this.morphline);
        SolrMorphlineTest.assertTrue((boolean)this.morphline.process(record));
        SolrMorphlineTest.assertEquals((long)1L, (long)this.collector.getRecords().size());
        SolrMorphlineTest.assertEquals((long)1L, (long)this.query("*:*").getResults().size());
        record = new Record();
        record.put("id", (Object)"id0");
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("set", null);
        record.put("text", map);
        SolrMorphlineTest.assertTrue((boolean)this.morphline.process(record));
        SolrDocumentList docs = this.query("*:*").getResults();
        SolrMorphlineTest.assertEquals((long)1L, (long)docs.size());
        SolrMorphlineTest.assertEquals((Object)"id0", (Object)((SolrDocument)docs.get(0)).getFirstValue("id"));
        SolrMorphlineTest.assertEquals((Object)123, (Object)((SolrDocument)docs.get(0)).getFirstValue("user_friends_count"));
        SolrMorphlineTest.assertNull((Object)((SolrDocument)docs.get(0)).getFieldValue("text"));
        record = new Record();
        record.put("id", (Object)"id0");
        record.put("text", Collections.singletonMap("set", "hello world"));
        SolrMorphlineTest.assertTrue((boolean)this.morphline.process(record));
        docs = this.query("*:*").getResults();
        SolrMorphlineTest.assertEquals((long)1L, (long)docs.size());
        SolrMorphlineTest.assertEquals((Object)"id0", (Object)((SolrDocument)docs.get(0)).getFirstValue("id"));
        SolrMorphlineTest.assertEquals((Object)123, (Object)((SolrDocument)docs.get(0)).getFirstValue("user_friends_count"));
        SolrMorphlineTest.assertEquals((Object)"hello world", (Object)((SolrDocument)docs.get(0)).getFirstValue("text"));
        record = new Record();
        record.put("id", (Object)"id0");
        record.put("text", (Object)ImmutableMap.of((Object)"add", (Object)"goodbye moon"));
        SolrMorphlineTest.assertTrue((boolean)this.morphline.process(record));
        docs = this.query("*:*").getResults();
        SolrMorphlineTest.assertEquals((long)1L, (long)docs.size());
        SolrMorphlineTest.assertEquals((Object)"id0", (Object)((SolrDocument)docs.get(0)).getFirstValue("id"));
        SolrMorphlineTest.assertEquals((Object)123, (Object)((SolrDocument)docs.get(0)).getFirstValue("user_friends_count"));
        SolrMorphlineTest.assertEquals(Arrays.asList("hello world", "goodbye moon"), (Object)((SolrDocument)docs.get(0)).get((Object)"text"));
        record = new Record();
        record.put("id", (Object)"id0");
        record.put("text", (Object)ImmutableMap.of((Object)"set", Arrays.asList("hello sun", "goodbye mars")));
        SolrMorphlineTest.assertTrue((boolean)this.morphline.process(record));
        docs = this.query("*:*").getResults();
        SolrMorphlineTest.assertEquals((long)1L, (long)docs.size());
        SolrMorphlineTest.assertEquals((Object)"id0", (Object)((SolrDocument)docs.get(0)).getFirstValue("id"));
        SolrMorphlineTest.assertEquals((Object)123, (Object)((SolrDocument)docs.get(0)).getFirstValue("user_friends_count"));
        SolrMorphlineTest.assertEquals(Arrays.asList("hello sun", "goodbye mars"), (Object)((SolrDocument)docs.get(0)).getFieldValue("text"));
        record = new Record();
        record.put("id", (Object)"id0");
        record.put("user_friends_count", (Object)ImmutableMap.of((Object)"inc", (Object)5));
        SolrMorphlineTest.assertTrue((boolean)this.morphline.process(record));
        docs = this.query("*:*").getResults();
        SolrMorphlineTest.assertEquals((long)1L, (long)docs.size());
        SolrMorphlineTest.assertEquals((Object)"id0", (Object)((SolrDocument)docs.get(0)).getFirstValue("id"));
        SolrMorphlineTest.assertEquals((Object)128, (Object)((SolrDocument)docs.get(0)).getFirstValue("user_friends_count"));
        SolrMorphlineTest.assertEquals(Arrays.asList("hello sun", "goodbye mars"), (Object)((SolrDocument)docs.get(0)).get((Object)"text"));
        Notifications.notifyCommitTransaction((Command)this.morphline);
        Notifications.notifyShutdown((Command)this.morphline);
    }

    @Test
    public void testLoadSolrWithDelete() throws Exception {
        this.morphline = this.createMorphline("test-morphlines" + File.separator + "loadSolrBasic");
        Record record = new Record();
        record.replaceValues("id", (Object)"id0");
        record.replaceValues("first_name", (Object)"Nadja");
        Notifications.notifyBeginTransaction((Command)this.morphline);
        SolrMorphlineTest.assertTrue((boolean)this.morphline.process(record.copy()));
        SolrMorphlineTest.assertEquals((long)1L, (long)this.query("*:*").getResults().size());
        record = new Record();
        record.replaceValues("id", (Object)"id1");
        SolrMorphlineTest.assertTrue((boolean)this.morphline.process(record.copy()));
        SolrMorphlineTest.assertEquals((long)2L, (long)this.query("*:*").getResults().size());
        record = new Record();
        record.replaceValues("_loadSolr_deleteById", (Object)"id0");
        SolrMorphlineTest.assertTrue((boolean)this.morphline.process(record.copy()));
        SolrMorphlineTest.assertEquals((long)1L, (long)this.query("*:*").getResults().size());
        record = new Record();
        record.replaceValues("_loadSolr_deleteById", (Object)"idNonExistent");
        SolrMorphlineTest.assertTrue((boolean)this.morphline.process(record.copy()));
        SolrMorphlineTest.assertEquals((long)1L, (long)this.query("*:*").getResults().size());
        record = new Record();
        record.replaceValues("id", (Object)"id2");
        SolrMorphlineTest.assertTrue((boolean)this.morphline.process(record.copy()));
        SolrMorphlineTest.assertEquals((long)2L, (long)this.query("*:*").getResults().size());
        record = new Record();
        record.replaceValues("id", (Object)"id200");
        SolrMorphlineTest.assertTrue((boolean)this.morphline.process(record.copy()));
        SolrMorphlineTest.assertEquals((long)3L, (long)this.query("*:*").getResults().size());
        record = new Record();
        record.replaceValues("_loadSolr_deleteByQuery", (Object)"id:id2*");
        record.put("_loadSolr_deleteByQuery", (Object)"text:NonExistent");
        SolrMorphlineTest.assertTrue((boolean)this.morphline.process(record.copy()));
        SolrMorphlineTest.assertEquals((long)1L, (long)this.query("*:*").getResults().size());
        record = new Record();
        record.put("_loadSolr_deleteByQuery", (Object)"id:NonExistent");
        record.put("_loadSolr_deleteByQuery", (Object)"text:NonExistent");
        SolrMorphlineTest.assertTrue((boolean)this.morphline.process(record.copy()));
        SolrMorphlineTest.assertEquals((long)1L, (long)this.query("*:*").getResults().size());
        record = new Record();
        record.replaceValues("id", (Object)"id3");
        SolrMorphlineTest.assertTrue((boolean)this.morphline.process(record.copy()));
        SolrMorphlineTest.assertEquals((long)2L, (long)this.query("*:*").getResults().size());
        SolrDocumentList docs = this.query("*:*").getResults();
        SolrMorphlineTest.assertEquals((long)2L, (long)docs.size());
        SolrMorphlineTest.assertEquals((Object)"id1", (Object)((SolrDocument)docs.get(0)).getFirstValue("id"));
        SolrMorphlineTest.assertNull((Object)((SolrDocument)docs.get(0)).getFirstValue("_loadSolr_deleteById"));
        SolrMorphlineTest.assertNull((Object)((SolrDocument)docs.get(0)).getFirstValue("_loadSolr_deleteByQuery"));
        SolrMorphlineTest.assertEquals((Object)"id3", (Object)((SolrDocument)docs.get(1)).getFirstValue("id"));
        SolrMorphlineTest.assertNull((Object)((SolrDocument)docs.get(1)).getFirstValue("_loadSolr_deleteById"));
        SolrMorphlineTest.assertNull((Object)((SolrDocument)docs.get(1)).getFirstValue("_loadSolr_deleteByQuery"));
        Notifications.notifyRollbackTransaction((Command)this.morphline);
        Notifications.notifyShutdown((Command)this.morphline);
    }

    @Test
    public void testLoadSolrWithChildDocuments() throws Exception {
        this.morphline = this.createMorphline("test-morphlines" + File.separator + "loadSolrWithChildDocuments");
        Record record = new Record();
        record.put("id", (Object)"id0");
        this.startSession();
        Notifications.notifyBeginTransaction((Command)this.morphline);
        SolrMorphlineTest.assertTrue((boolean)this.morphline.process(record));
        SolrMorphlineTest.assertEquals((long)1L, (long)this.collector.getNumStartEvents());
        Notifications.notifyCommitTransaction((Command)this.morphline);
        SolrDocumentList docs = this.query("{!parent which='content_type:parent'}id:bar").getResults();
        SolrMorphlineTest.assertEquals((long)1L, (long)docs.size());
        SolrMorphlineTest.assertEquals((Object)"id0", (Object)((SolrDocument)docs.get(0)).getFirstValue("id"));
        docs = this.query("*:*").getResults();
        SolrMorphlineTest.assertEquals((long)3L, (long)docs.size());
    }

    @Test
    public void testTokenizeText() throws Exception {
        this.morphline = this.createMorphline("test-morphlines" + File.separator + "tokenizeText");
        for (int i = 0; i < 3; ++i) {
            Record record = new Record();
            record.put("message", (Object)"Hello World!");
            record.put("message", (Object)"\nFoo@Bar.com #%()123");
            Record expected = record.copy();
            expected.getFields().putAll((Object)"tokens", Arrays.asList("hello", "world", "foo", "bar.com", "123"));
            this.collector.reset();
            this.startSession();
            Notifications.notifyBeginTransaction((Command)this.morphline);
            SolrMorphlineTest.assertTrue((boolean)this.morphline.process(record));
            SolrMorphlineTest.assertEquals((long)1L, (long)this.collector.getNumStartEvents());
            Notifications.notifyCommitTransaction((Command)this.morphline);
            SolrMorphlineTest.assertEquals((Object)expected, (Object)this.collector.getFirstRecord());
        }
    }
}

