/*
 * Decompiled with CFR 0.152.
 */
package org.kitesdk.morphline.solr;

import com.carrotsearch.randomizedtesting.annotations.ThreadLeakAction;
import com.carrotsearch.randomizedtesting.annotations.ThreadLeakLingering;
import com.carrotsearch.randomizedtesting.annotations.ThreadLeakScope;
import com.carrotsearch.randomizedtesting.annotations.ThreadLeakZombies;
import java.io.File;
import java.io.IOException;
import java.util.Iterator;
import org.apache.lucene.util.LuceneTestCase;
import org.apache.solr.client.solrj.SolrQuery;
import org.apache.solr.client.solrj.SolrRequest;
import org.apache.solr.client.solrj.SolrServerException;
import org.apache.solr.client.solrj.request.QueryRequest;
import org.apache.solr.client.solrj.response.QueryResponse;
import org.apache.solr.common.params.CollectionParams;
import org.apache.solr.common.params.ModifiableSolrParams;
import org.apache.solr.common.params.SolrParams;
import org.apache.solr.common.util.NamedList;
import org.kitesdk.morphline.api.Command;
import org.kitesdk.morphline.api.Record;
import org.kitesdk.morphline.base.Notifications;
import org.kitesdk.morphline.solr.AbstractSolrMorphlineZkTest;

@ThreadLeakAction(value={ThreadLeakAction.Action.WARN})
@ThreadLeakLingering(linger=0)
@ThreadLeakZombies(value=ThreadLeakZombies.Consequence.CONTINUE)
@ThreadLeakScope(value=ThreadLeakScope.Scope.NONE)
@LuceneTestCase.SuppressCodecs(value={"Lucene3x", "Lucene40"})
public class SolrMorphlineZkAliasTest
extends AbstractSolrMorphlineZkTest {
    public void doTest() throws Exception {
        this.waitForRecoveriesToFinish(false);
        this.createAlias("aliascollection", "collection1");
        this.morphline = this.parse("test-morphlines" + File.separator + "loadSolrBasic", "aliascollection");
        Record record = new Record();
        record.put("id", (Object)"id0-innsbruck");
        record.put("text", (Object)"mytext");
        record.put("user_screen_name", (Object)"foo");
        record.put("first_name", (Object)"Nadja");
        this.startSession();
        SolrMorphlineZkAliasTest.assertEquals((long)1L, (long)this.collector.getNumStartEvents());
        Notifications.notifyBeginTransaction((Command)this.morphline);
        SolrMorphlineZkAliasTest.assertTrue((boolean)this.morphline.process(record));
        record = new Record();
        record.put("id", (Object)"id1-innsbruck");
        record.put("text", (Object)"mytext1");
        record.put("user_screen_name", (Object)"foo1");
        record.put("first_name", (Object)"Nadja1");
        SolrMorphlineZkAliasTest.assertTrue((boolean)this.morphline.process(record));
        Record expected = new Record();
        expected.put("id", (Object)"id0-innsbruck");
        expected.put("text", (Object)"mytext");
        expected.put("user_screen_name", (Object)"foo");
        Iterator citer = this.collector.getRecords().iterator();
        SolrMorphlineZkAliasTest.assertEquals((Object)expected, citer.next());
        Record expected2 = new Record();
        expected2.put("id", (Object)"id1-innsbruck");
        expected2.put("text", (Object)"mytext1");
        expected2.put("user_screen_name", (Object)"foo1");
        SolrMorphlineZkAliasTest.assertEquals((Object)expected2, citer.next());
        SolrMorphlineZkAliasTest.assertFalse((boolean)citer.hasNext());
        this.commit();
        QueryResponse rsp = this.cloudClient.query((SolrParams)new SolrQuery("*:*").setRows(Integer.valueOf(100000)).addSort("id", SolrQuery.ORDER.asc));
        Iterator iter = rsp.getResults().iterator();
        SolrMorphlineZkAliasTest.assertEquals((Object)expected.getFields(), this.next(iter));
        SolrMorphlineZkAliasTest.assertEquals((Object)expected2.getFields(), this.next(iter));
        SolrMorphlineZkAliasTest.assertFalse((boolean)iter.hasNext());
        Notifications.notifyRollbackTransaction((Command)this.morphline);
        Notifications.notifyShutdown((Command)this.morphline);
        this.createAlias("aliascollection", "collection1,collection2");
        try {
            this.parse("test-morphlines" + File.separator + "loadSolrBasic", "aliascollection");
            SolrMorphlineZkAliasTest.fail((String)"Expected IAE because update alias maps to multiple collections");
        }
        catch (IllegalArgumentException e) {
            // empty catch block
        }
    }

    private NamedList<Object> createAlias(String alias, String collections) throws SolrServerException, IOException {
        ModifiableSolrParams params = new ModifiableSolrParams();
        params.set("collections", new String[]{collections});
        params.set("name", new String[]{alias});
        params.set("action", new String[]{CollectionParams.CollectionAction.CREATEALIAS.toString()});
        QueryRequest request = new QueryRequest((SolrParams)params);
        request.setPath("/admin/collections");
        return this.cloudClient.request((SolrRequest)request);
    }
}

