/*
 * Decompiled with CFR 0.152.
 */
package org.kitesdk.morphline.solr;

import com.carrotsearch.randomizedtesting.annotations.ThreadLeakAction;
import com.carrotsearch.randomizedtesting.annotations.ThreadLeakLingering;
import com.carrotsearch.randomizedtesting.annotations.ThreadLeakScope;
import com.carrotsearch.randomizedtesting.annotations.ThreadLeakZombies;
import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.io.Files;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import org.apache.avro.Schema;
import org.apache.avro.file.DataFileReader;
import org.apache.avro.generic.GenericData;
import org.apache.avro.generic.GenericDatumReader;
import org.apache.avro.io.DatumReader;
import org.apache.lucene.util.LuceneTestCase;
import org.apache.solr.client.solrj.SolrQuery;
import org.apache.solr.client.solrj.response.QueryResponse;
import org.apache.solr.common.params.SolrParams;
import org.kitesdk.morphline.api.Command;
import org.kitesdk.morphline.api.Record;
import org.kitesdk.morphline.base.Notifications;
import org.kitesdk.morphline.solr.AbstractSolrMorphlineZkTest;

@ThreadLeakAction(value={ThreadLeakAction.Action.WARN})
@ThreadLeakLingering(linger=0)
@ThreadLeakZombies(value=ThreadLeakZombies.Consequence.CONTINUE)
@ThreadLeakScope(value=ThreadLeakScope.Scope.NONE)
@LuceneTestCase.SuppressCodecs(value={"Lucene3x", "Lucene40"})
public class SolrMorphlineZkAvroTest
extends AbstractSolrMorphlineZkTest {
    public void doTest() throws Exception {
        int i;
        Joiner joiner = Joiner.on((String)File.separator);
        File file = new File(joiner.join((Object)"target/test-classes", (Object)"test-documents", new Object[]{"sample-statuses-20120906-141433-medium.avro"}));
        this.waitForRecoveriesToFinish(false);
        this.morphline = this.parse("test-morphlines" + File.separator + "tutorialReadAvroContainer");
        Record record = new Record();
        byte[] body = Files.toByteArray((File)file);
        record.put("_attachment_body", (Object)body);
        this.startSession();
        Notifications.notifyBeginTransaction((Command)this.morphline);
        SolrMorphlineZkAvroTest.assertTrue((boolean)this.morphline.process(record));
        SolrMorphlineZkAvroTest.assertEquals((long)1L, (long)this.collector.getNumStartEvents());
        this.commit();
        QueryResponse rsp = this.cloudClient.query((SolrParams)new SolrQuery("*:*").setRows(Integer.valueOf(100000)).addSort("id", SolrQuery.ORDER.asc));
        SolrMorphlineZkAvroTest.assertEquals((long)2104L, (long)this.collector.getRecords().size());
        SolrMorphlineZkAvroTest.assertEquals((long)this.collector.getRecords().size(), (long)rsp.getResults().size());
        Collections.sort(this.collector.getRecords(), new Comparator<Record>(){

            @Override
            public int compare(Record r1, Record r2) {
                return r1.get("id").toString().compareTo(r2.get("id").toString());
            }
        });
        ArrayList<GenericData.Record> records = new ArrayList<GenericData.Record>();
        DataFileReader reader = new DataFileReader(file, (DatumReader)new GenericDatumReader());
        while (reader.hasNext()) {
            GenericData.Record expected = (GenericData.Record)reader.next();
            records.add(expected);
        }
        SolrMorphlineZkAvroTest.assertEquals((long)this.collector.getRecords().size(), (long)records.size());
        Collections.sort(records, new Comparator<GenericData.Record>(){

            @Override
            public int compare(GenericData.Record r1, GenericData.Record r2) {
                return r1.get("id").toString().compareTo(r2.get("id").toString());
            }
        });
        Object lastId = null;
        for (i = 0; i < records.size(); ++i) {
            Object id = records.get(i);
            if (id != null && id.equals(lastId)) {
                throw new IllegalStateException("Detected duplicate id. Test input data must not contain duplicate ids!");
            }
            lastId = id;
        }
        for (i = 0; i < records.size(); ++i) {
        }
        Iterator rspIter = rsp.getResults().iterator();
        for (int i2 = 0; i2 < records.size(); ++i2) {
            Record actual = (Record)this.collector.getRecords().get(i2);
            GenericData.Record expected = (GenericData.Record)records.get(i2);
            Preconditions.checkNotNull((Object)expected);
            this.assertTweetEquals(expected, actual, i2);
            actual = new Record();
            actual.getFields().putAll(this.next(rspIter));
            this.assertTweetEquals(expected, actual, i2);
        }
        Notifications.notifyRollbackTransaction((Command)this.morphline);
        Notifications.notifyShutdown((Command)this.morphline);
        this.cloudClient.shutdown();
    }

    private void assertTweetEquals(GenericData.Record expected, Record actual, int i) {
        String[] fieldNames;
        Preconditions.checkNotNull((Object)expected);
        Preconditions.checkNotNull((Object)actual);
        for (String fieldName : fieldNames = new String[]{"id", "in_reply_to_status_id", "in_reply_to_user_id", "retweet_count", "text"}) {
            SolrMorphlineZkAvroTest.assertEquals((String)(i + " fieldName: " + fieldName), (Object)expected.get(fieldName).toString(), (Object)actual.getFirstValue(fieldName).toString());
        }
    }

    private String toString(GenericData.Record avroRecord) {
        Record record = new Record();
        for (Schema.Field field : avroRecord.getSchema().getFields()) {
            record.put(field.name(), avroRecord.get(field.pos()));
        }
        return record.toString();
    }
}

