/*
 * Decompiled with CFR 0.152.
 */
package org.kitesdk.morphline.solr;

import com.carrotsearch.randomizedtesting.annotations.ThreadLeakAction;
import com.carrotsearch.randomizedtesting.annotations.ThreadLeakLingering;
import com.carrotsearch.randomizedtesting.annotations.ThreadLeakScope;
import com.carrotsearch.randomizedtesting.annotations.ThreadLeakZombies;
import java.io.File;
import java.util.Iterator;
import org.apache.lucene.util.LuceneTestCase;
import org.apache.solr.client.solrj.SolrQuery;
import org.apache.solr.client.solrj.response.QueryResponse;
import org.apache.solr.common.params.SolrParams;
import org.kitesdk.morphline.api.Command;
import org.kitesdk.morphline.api.Record;
import org.kitesdk.morphline.base.Notifications;
import org.kitesdk.morphline.solr.AbstractSolrMorphlineZkTest;

@ThreadLeakAction(value={ThreadLeakAction.Action.WARN})
@ThreadLeakLingering(linger=0)
@ThreadLeakZombies(value=ThreadLeakZombies.Consequence.CONTINUE)
@ThreadLeakScope(value=ThreadLeakScope.Scope.NONE)
@LuceneTestCase.SuppressCodecs(value={"Lucene3x", "Lucene40"})
public class SolrMorphlineZkTest
extends AbstractSolrMorphlineZkTest {
    public void doTest() throws Exception {
        this.waitForRecoveriesToFinish(false);
        this.morphline = this.parse("test-morphlines" + File.separator + "loadSolrBasic");
        Record record = new Record();
        record.put("id", (Object)"id0-innsbruck");
        record.put("text", (Object)"mytext");
        record.put("user_screen_name", (Object)"foo");
        record.put("first_name", (Object)"Nadja");
        this.startSession();
        SolrMorphlineZkTest.assertEquals((long)1L, (long)this.collector.getNumStartEvents());
        Notifications.notifyBeginTransaction((Command)this.morphline);
        SolrMorphlineZkTest.assertTrue((boolean)this.morphline.process(record));
        record = new Record();
        record.put("id", (Object)"id1-innsbruck");
        record.put("text", (Object)"mytext1");
        record.put("user_screen_name", (Object)"foo1");
        record.put("first_name", (Object)"Nadja1");
        SolrMorphlineZkTest.assertTrue((boolean)this.morphline.process(record));
        Record expected = new Record();
        expected.put("id", (Object)"id0-innsbruck");
        expected.put("text", (Object)"mytext");
        expected.put("user_screen_name", (Object)"foo");
        Iterator citer = this.collector.getRecords().iterator();
        SolrMorphlineZkTest.assertEquals((Object)expected, citer.next());
        Record expected2 = new Record();
        expected2.put("id", (Object)"id1-innsbruck");
        expected2.put("text", (Object)"mytext1");
        expected2.put("user_screen_name", (Object)"foo1");
        SolrMorphlineZkTest.assertEquals((Object)expected2, citer.next());
        SolrMorphlineZkTest.assertFalse((boolean)citer.hasNext());
        this.commit();
        QueryResponse rsp = this.cloudClient.query((SolrParams)new SolrQuery("*:*").setRows(Integer.valueOf(100000)).addSort("id", SolrQuery.ORDER.asc));
        Iterator iter = rsp.getResults().iterator();
        SolrMorphlineZkTest.assertEquals((Object)expected.getFields(), this.next(iter));
        SolrMorphlineZkTest.assertEquals((Object)expected2.getFields(), this.next(iter));
        SolrMorphlineZkTest.assertFalse((boolean)iter.hasNext());
        Notifications.notifyRollbackTransaction((Command)this.morphline);
        Notifications.notifyShutdown((Command)this.morphline);
        this.cloudClient.shutdown();
    }
}

