/*
 * Decompiled with CFR 0.152.
 */
package org.kitesdk.morphline.solr;

import com.codahale.metrics.Timer;
import com.typesafe.config.Config;
import com.typesafe.config.ConfigFactory;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.solr.client.solrj.SolrServerException;
import org.apache.solr.common.SolrInputDocument;
import org.kitesdk.morphline.api.Command;
import org.kitesdk.morphline.api.CommandBuilder;
import org.kitesdk.morphline.api.MorphlineContext;
import org.kitesdk.morphline.api.MorphlineRuntimeException;
import org.kitesdk.morphline.api.Record;
import org.kitesdk.morphline.base.AbstractCommand;
import org.kitesdk.morphline.base.Configs;
import org.kitesdk.morphline.base.Notifications;
import org.kitesdk.morphline.solr.DocumentLoader;
import org.kitesdk.morphline.solr.SolrLocator;

public final class LoadSolrBuilder
implements CommandBuilder {
    public static final String SOLR_LOCATOR_PARAM = "solrLocator";
    public static final String LOAD_SOLR_DELETE_BY_ID = "_loadSolr_deleteById";
    public static final String LOAD_SOLR_DELETE_BY_QUERY = "_loadSolr_deleteByQuery";
    public static final String LOAD_SOLR_CHILD_DOCUMENTS = "_loadSolr_childDocuments";

    public Collection<String> getNames() {
        return Collections.singletonList("loadSolr");
    }

    public Command build(Config config, Command parent, Command child, MorphlineContext context) {
        return new LoadSolr(this, config, parent, child, context);
    }

    private static final class LoadSolr
    extends AbstractCommand {
        private final DocumentLoader loader;
        private final Map<String, Float> boosts = new HashMap<String, Float>();
        private final Timer elapsedTime;
        private final boolean isDryRun;

        public LoadSolr(CommandBuilder builder, Config config, Command parent, Command child, MorphlineContext context) {
            super(builder, config, parent, child, context);
            Config solrLocatorConfig = this.getConfigs().getConfig(config, LoadSolrBuilder.SOLR_LOCATOR_PARAM);
            SolrLocator locator = new SolrLocator(solrLocatorConfig, context);
            this.LOG.debug("solrLocator: {}", (Object)locator);
            this.loader = locator.getLoader();
            Config boostsConfig = this.getConfigs().getConfig(config, "boosts", ConfigFactory.empty());
            for (Map.Entry entry : new Configs().getEntrySet(boostsConfig)) {
                String fieldName = (String)entry.getKey();
                float boost = Float.parseFloat(entry.getValue().toString().trim());
                this.boosts.put(fieldName, Float.valueOf(boost));
            }
            this.isDryRun = context.getTypedSettings().getBoolean("isDryRun", false);
            this.validateArguments();
            this.elapsedTime = this.getTimer(new String[]{"elapsedTime"});
        }

        protected void doNotify(Record notification) {
            for (Object event : Notifications.getLifecycleEvents((Record)notification)) {
                if (event == Notifications.LifecycleEvent.BEGIN_TRANSACTION) {
                    try {
                        this.loader.beginTransaction();
                        continue;
                    }
                    catch (SolrServerException e) {
                        throw new MorphlineRuntimeException((Throwable)e);
                    }
                    catch (IOException e) {
                        throw new MorphlineRuntimeException((Throwable)e);
                    }
                }
                if (event == Notifications.LifecycleEvent.COMMIT_TRANSACTION) {
                    try {
                        this.loader.commitTransaction();
                        continue;
                    }
                    catch (SolrServerException e) {
                        throw new MorphlineRuntimeException((Throwable)e);
                    }
                    catch (IOException e) {
                        throw new MorphlineRuntimeException((Throwable)e);
                    }
                }
                if (event == Notifications.LifecycleEvent.ROLLBACK_TRANSACTION) {
                    try {
                        this.loader.rollbackTransaction();
                        continue;
                    }
                    catch (SolrServerException e) {
                        throw new MorphlineRuntimeException((Throwable)e);
                    }
                    catch (IOException e) {
                        throw new MorphlineRuntimeException((Throwable)e);
                    }
                }
                if (event != Notifications.LifecycleEvent.SHUTDOWN) continue;
                try {
                    this.loader.shutdown();
                }
                catch (SolrServerException e) {
                    throw new MorphlineRuntimeException((Throwable)e);
                }
                catch (IOException e) {
                    throw new MorphlineRuntimeException((Throwable)e);
                }
            }
            super.doNotify(notification);
        }

        protected boolean doProcess(Record record) {
            Timer.Context timerContext = this.elapsedTime.time();
            List deleteById = record.get(LoadSolrBuilder.LOAD_SOLR_DELETE_BY_ID);
            List deleteByQuery = record.get(LoadSolrBuilder.LOAD_SOLR_DELETE_BY_QUERY);
            try {
                if (deleteById.size() == 0 && deleteByQuery.size() == 0) {
                    SolrInputDocument doc = this.convert(record);
                    if (this.isDryRun) {
                        System.out.println("dryrun: update: " + doc);
                    } else {
                        this.loader.load(doc);
                    }
                } else {
                    for (Object id : deleteById) {
                        if (this.isDryRun) {
                            System.out.println("dryrun: deleteById: " + id.toString());
                            continue;
                        }
                        this.loader.deleteById(id.toString());
                    }
                    for (Object query : deleteByQuery) {
                        if (this.isDryRun) {
                            System.out.println("dryrun: deleteByQuery: " + query.toString());
                            continue;
                        }
                        this.loader.deleteByQuery(query.toString());
                    }
                }
            }
            catch (IOException e) {
                throw new MorphlineRuntimeException((Throwable)e);
            }
            catch (SolrServerException e) {
                throw new MorphlineRuntimeException((Throwable)e);
            }
            finally {
                timerContext.stop();
            }
            return super.doProcess(record);
        }

        private SolrInputDocument convert(Record record) {
            Map map = record.getFields().asMap();
            SolrInputDocument doc = new SolrInputDocument(new HashMap(2 * map.size()));
            for (Map.Entry entry : map.entrySet()) {
                String key = (String)entry.getKey();
                if (LoadSolrBuilder.LOAD_SOLR_CHILD_DOCUMENTS.equals(key)) {
                    for (Object value : (Collection)entry.getValue()) {
                        if (value instanceof Record) {
                            value = this.convert((Record)value);
                        }
                        if (value instanceof SolrInputDocument) {
                            doc.addChildDocument((SolrInputDocument)value);
                            continue;
                        }
                        throw new MorphlineRuntimeException("Child document must be of class " + Record.class.getName() + " or " + SolrInputDocument.class.getName() + ": " + value);
                    }
                    continue;
                }
                doc.setField(key, entry.getValue(), this.getBoost(key));
            }
            return doc;
        }

        private float getBoost(String key) {
            Float boost;
            if (this.boosts.size() > 0 && (boost = this.boosts.get(key)) != null) {
                return boost.floatValue();
            }
            return 1.0f;
        }
    }
}

