/*
 * Decompiled with CFR 0.152.
 */
package org.kitesdk.morphline.solr;

import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.typesafe.config.Config;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.TreeMap;
import org.apache.solr.schema.IndexSchema;
import org.kitesdk.morphline.api.Command;
import org.kitesdk.morphline.api.CommandBuilder;
import org.kitesdk.morphline.api.MorphlineContext;
import org.kitesdk.morphline.api.Record;
import org.kitesdk.morphline.base.AbstractCommand;
import org.kitesdk.morphline.solr.SolrLocator;

public final class SanitizeUnknownSolrFieldsBuilder
implements CommandBuilder {
    public Collection<String> getNames() {
        return Collections.singletonList("sanitizeUnknownSolrFields");
    }

    public Command build(Config config, Command parent, Command child, MorphlineContext context) {
        return new SanitizeUnknownSolrFields(this, config, parent, child, context);
    }

    private static final class SanitizeUnknownSolrFields
    extends AbstractCommand {
        private final IndexSchema schema;
        private final String renameToPrefix;

        public SanitizeUnknownSolrFields(CommandBuilder builder, Config config, Command parent, Command child, MorphlineContext context) {
            super(builder, config, parent, child, context);
            Config solrLocatorConfig = this.getConfigs().getConfig(config, "solrLocator");
            SolrLocator locator = new SolrLocator(solrLocatorConfig, context);
            this.LOG.debug("solrLocator: {}", (Object)locator);
            this.schema = locator.getIndexSchema();
            Preconditions.checkNotNull((Object)this.schema);
            this.LOG.trace("Solr schema: \n{}", (Object)Joiner.on((String)"\n").join(new TreeMap(this.schema.getFields()).values()));
            String str = this.getConfigs().getString(config, "renameToPrefix", "").trim();
            this.renameToPrefix = str.length() > 0 ? str : null;
            this.validateArguments();
        }

        protected boolean doProcess(Record record) {
            ArrayList entries = new ArrayList(record.getFields().asMap().entrySet());
            for (Map.Entry entry : entries) {
                String key = (String)entry.getKey();
                if (this.schema.getFieldOrNull(key) != null || "_loadSolr_deleteById".equals(key) || "_loadSolr_deleteByQuery".equals(key) || "_loadSolr_childDocuments".equals(key)) continue;
                this.LOG.debug("Sanitizing unknown Solr field: {}", (Object)key);
                Collection values = (Collection)entry.getValue();
                if (this.renameToPrefix != null) {
                    record.getFields().putAll((Object)(this.renameToPrefix + key), (Iterable)values);
                }
                values.clear();
            }
            return super.doProcess(record);
        }
    }
}

