/*
 * Decompiled with CFR 0.152.
 */
package org.kitesdk.morphline.solr;

import com.google.common.base.Preconditions;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.solr.client.solrj.SolrServer;
import org.apache.solr.client.solrj.SolrServerException;
import org.apache.solr.client.solrj.impl.CloudSolrServer;
import org.apache.solr.client.solrj.impl.ConcurrentUpdateSolrServer;
import org.apache.solr.client.solrj.request.UpdateRequest;
import org.apache.solr.client.solrj.response.SolrPingResponse;
import org.apache.solr.client.solrj.response.UpdateResponse;
import org.apache.solr.common.SolrInputDocument;
import org.kitesdk.morphline.solr.DocumentLoader;
import org.kitesdk.morphline.solr.SafeConcurrentUpdateSolrServer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SolrServerDocumentLoader
implements DocumentLoader {
    private final SolrServer server;
    private long numSentItems = 0L;
    private final int batchSize;
    private final List batch = new ArrayList();
    private static final Logger LOGGER = LoggerFactory.getLogger(SolrServerDocumentLoader.class);

    public SolrServerDocumentLoader(SolrServer server, int batchSize) {
        if (server == null) {
            throw new IllegalArgumentException("solr server must not be null");
        }
        this.server = server;
        if (batchSize <= 0) {
            throw new IllegalArgumentException("batchSize must be a positive number: " + batchSize);
        }
        this.batchSize = batchSize;
    }

    @Override
    public void beginTransaction() {
        LOGGER.trace("beginTransaction");
        this.batch.clear();
        this.numSentItems = 0L;
        if (this.server instanceof SafeConcurrentUpdateSolrServer) {
            ((SafeConcurrentUpdateSolrServer)this.server).clearException();
        }
    }

    @Override
    public void load(SolrInputDocument doc) throws IOException, SolrServerException {
        Preconditions.checkNotNull((Object)doc);
        LOGGER.trace("load doc: {}", (Object)doc);
        this.addItem(doc);
    }

    @Override
    public void deleteById(String id) throws IOException, SolrServerException {
        Preconditions.checkNotNull((Object)id);
        LOGGER.trace("deleteById: {}", (Object)id);
        this.addItem(id);
    }

    @Override
    public void deleteByQuery(String query) throws IOException, SolrServerException {
        Preconditions.checkNotNull((Object)query);
        LOGGER.trace("deleteByQuery: {}", (Object)query);
        this.addItem(new QueryStringHolder(query));
    }

    @Override
    public void commitTransaction() throws SolrServerException, IOException {
        LOGGER.trace("commitTransaction");
        if (this.batch.size() > 0) {
            this.sendBatch();
        }
        if (this.numSentItems > 0L && this.server instanceof ConcurrentUpdateSolrServer) {
            ((ConcurrentUpdateSolrServer)this.server).blockUntilFinished();
        }
    }

    private void addItem(Object item) throws SolrServerException, IOException {
        this.batch.add(item);
        if (this.batch.size() >= this.batchSize) {
            this.sendBatch();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendBatch() throws SolrServerException, IOException {
        this.numSentItems += (long)this.batch.size();
        try {
            ArrayList<SolrInputDocument> loads = new ArrayList<SolrInputDocument>(this.batch.size());
            ArrayList deletes = new ArrayList(this.batch.size());
            for (Object item : this.batch) {
                if (item instanceof SolrInputDocument) {
                    this.sendDeletes(deletes);
                    loads.add((SolrInputDocument)item);
                    continue;
                }
                if (item instanceof String) {
                    this.sendLoads(loads);
                    deletes.add(item);
                    continue;
                }
                if (item instanceof QueryStringHolder) {
                    this.sendLoads(loads);
                    deletes.add(item);
                    continue;
                }
                throw new IllegalStateException("unreachable");
            }
            this.sendLoads(loads);
            this.sendDeletes(deletes);
        }
        finally {
            this.batch.clear();
        }
    }

    private void sendLoads(List<SolrInputDocument> loads) throws SolrServerException, IOException {
        if (loads.size() > 0) {
            this.log(this.server.add(loads));
            loads.clear();
        }
    }

    private void sendDeletes(List deletes) throws SolrServerException, IOException {
        if (deletes.size() > 0) {
            UpdateRequest req = new UpdateRequest();
            for (Object delete : deletes) {
                if (delete instanceof String) {
                    req.deleteById((String)delete);
                    continue;
                }
                String query = ((QueryStringHolder)delete).getQuery();
                req.deleteByQuery(query);
            }
            req.setCommitWithin(-1);
            this.log(req.process(this.server));
            deletes.clear();
        }
    }

    private void log(UpdateResponse response) {
    }

    @Override
    public UpdateResponse rollbackTransaction() throws SolrServerException, IOException {
        LOGGER.trace("rollback");
        if (!(this.server instanceof CloudSolrServer)) {
            return this.server.rollback();
        }
        return new UpdateResponse();
    }

    @Override
    public void shutdown() {
        LOGGER.trace("shutdown");
        this.server.shutdown();
    }

    @Override
    public SolrPingResponse ping() throws SolrServerException, IOException {
        LOGGER.trace("ping");
        return this.server.ping();
    }

    public SolrServer getSolrServer() {
        return this.server;
    }

    private static final class QueryStringHolder {
        private String query;

        public QueryStringHolder(String query) {
            this.query = query;
        }

        public String getQuery() {
            return this.query;
        }
    }
}

