/*
 * Decompiled with CFR 0.152.
 */
package org.kitesdk.morphline.solr;

import com.google.common.base.Preconditions;
import com.typesafe.config.Config;
import java.io.IOException;
import java.io.Reader;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.tokenattributes.CharTermAttribute;
import org.apache.solr.schema.FieldType;
import org.apache.solr.schema.IndexSchema;
import org.kitesdk.morphline.api.Command;
import org.kitesdk.morphline.api.CommandBuilder;
import org.kitesdk.morphline.api.MorphlineCompilationException;
import org.kitesdk.morphline.api.MorphlineContext;
import org.kitesdk.morphline.api.MorphlineRuntimeException;
import org.kitesdk.morphline.api.Record;
import org.kitesdk.morphline.base.AbstractCommand;
import org.kitesdk.morphline.solr.SolrLocator;

public final class TokenizeTextBuilder
implements CommandBuilder {
    public Collection<String> getNames() {
        return Collections.singletonList("tokenizeText");
    }

    public Command build(Config config, Command parent, Command child, MorphlineContext context) {
        return new TokenizeText(this, config, parent, child, context);
    }

    private static final class ReusableStringReader
    extends Reader {
        private int pos = 0;
        private int size = 0;
        private String s = null;

        private ReusableStringReader() {
        }

        void setValue(String s) {
            this.s = s;
            this.size = s.length();
            this.pos = 0;
        }

        @Override
        public int read() {
            if (this.pos < this.size) {
                return this.s.charAt(this.pos++);
            }
            this.s = null;
            return -1;
        }

        @Override
        public int read(char[] c, int off, int len) {
            if (this.pos < this.size) {
                len = Math.min(len, this.size - this.pos);
                this.s.getChars(this.pos, this.pos + len, c, off);
                this.pos += len;
                return len;
            }
            this.s = null;
            return -1;
        }

        @Override
        public void close() {
            this.pos = this.size;
            this.s = null;
        }
    }

    private static final class TokenizeText
    extends AbstractCommand {
        private final String inputFieldName;
        private final String outputFieldName;
        private final Analyzer analyzer;
        private final CharTermAttribute token;
        private final ReusableStringReader reader = new ReusableStringReader();

        public TokenizeText(CommandBuilder builder, Config config, Command parent, Command child, MorphlineContext context) {
            super(builder, config, parent, child, context);
            this.inputFieldName = this.getConfigs().getString(config, "inputField");
            this.outputFieldName = this.getConfigs().getString(config, "outputField");
            String solrFieldType = this.getConfigs().getString(config, "solrFieldType");
            Config solrLocatorConfig = this.getConfigs().getConfig(config, "solrLocator");
            SolrLocator locator = new SolrLocator(solrLocatorConfig, context);
            this.LOG.debug("solrLocator: {}", (Object)locator);
            IndexSchema schema = locator.getIndexSchema();
            FieldType fieldType = schema.getFieldTypeByName(solrFieldType);
            if (fieldType == null) {
                throw new MorphlineCompilationException("Missing Solr field type in schema.xml for name: " + solrFieldType, config);
            }
            this.analyzer = fieldType.getIndexAnalyzer();
            Preconditions.checkNotNull((Object)this.analyzer);
            try {
                this.token = (CharTermAttribute)this.analyzer.tokenStream("content", (Reader)this.reader).addAttribute(CharTermAttribute.class);
            }
            catch (IOException e) {
                throw new MorphlineCompilationException("Cannot create token stream", config, (Throwable)e);
            }
            Preconditions.checkNotNull((Object)this.token);
            this.validateArguments();
        }

        protected boolean doProcess(Record record) {
            try {
                List outputValues = record.get(this.outputFieldName);
                for (Object value : record.get(this.inputFieldName)) {
                    this.reader.setValue(value.toString());
                    TokenStream tokenStream = this.analyzer.tokenStream("content", (Reader)this.reader);
                    tokenStream.reset();
                    while (tokenStream.incrementToken()) {
                        if (this.token.length() <= 0) continue;
                        String tokenStr = new String(this.token.buffer(), 0, this.token.length());
                        outputValues.add(tokenStr);
                    }
                    tokenStream.end();
                    tokenStream.close();
                }
            }
            catch (IOException e) {
                throw new MorphlineRuntimeException((Throwable)e);
            }
            return super.doProcess(record);
        }
    }
}

