/*
 * Decompiled with CFR 0.152.
 */
package org.kohsuke.ajaxterm;

import com.sun.jna.Memory;
import com.sun.jna.ptr.IntByReference;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileDescriptor;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.kohsuke.ajaxterm.CLibrary;
import org.kohsuke.ajaxterm.ProcessWithPty;
import org.kohsuke.ajaxterm.UtilLibrary;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PtyProcessBuilder {
    private List<String> commands = new ArrayList<String>();
    private File pwd;
    private Map<String, String> environment = new HashMap<String, String>();

    public PtyProcessBuilder commands(List<String> cmds) {
        this.commands.addAll(cmds);
        return this;
    }

    public PtyProcessBuilder commands(String ... cmds) {
        return this.commands(Arrays.asList(cmds));
    }

    public List<String> commands() {
        return this.commands();
    }

    public PtyProcessBuilder pwd(File pwd) {
        this.pwd = pwd;
        return this;
    }

    public PtyProcessBuilder env(String name, String value) {
        this.environment.put(name, value);
        return this;
    }

    public PtyProcessBuilder envs(Map<String, String> envs) {
        this.environment.putAll(envs);
        return this;
    }

    public Map<String, String> envs() {
        return this.environment;
    }

    public ProcessWithPty forkWithHelper() throws IOException {
        File py = File.createTempFile("ttycontrol", "py");
        InputStream in = PtyProcessBuilder.class.getResourceAsStream("ttycontrol.py");
        this.copyToFile(in, py);
        py.deleteOnExit();
        ProcessBuilder pb = new ProcessBuilder(new String[0]);
        if (this.pwd != null) {
            pb.directory(this.pwd);
        }
        pb.redirectErrorStream(true);
        pb.environment().putAll(this.environment);
        List<String> pyCmds = pb.command();
        pyCmds.add("python");
        pyCmds.add("-u");
        pyCmds.add(py.getAbsolutePath());
        pyCmds.addAll(this.commands);
        final Process base = pb.start();
        return new ProcessWithPty(){
            final DataOutputStream out;
            {
                this.out = new DataOutputStream(base.getOutputStream());
            }

            public void setWindowSize(int width, int height) throws IOException {
                this.out.write(3);
                this.out.writeShort(4);
                this.out.writeShort(height);
                this.out.writeShort(width);
                this.out.flush();
            }

            public void kill(int signal) throws IOException {
                this.out.write(2);
                this.out.writeShort(2);
                this.out.writeShort(signal);
                this.out.flush();
            }

            public OutputStream getOutputStream() {
                return new OutputStream(){

                    public void write(int b) throws IOException {
                        this.write(new byte[]{(byte)b});
                    }

                    public void write(byte[] b, int off, int len) throws IOException {
                        while (len > 0) {
                            int chunk = len & Short.MAX_VALUE;
                            out.write(1);
                            out.writeShort(chunk);
                            out.write(b, off, chunk);
                            off += chunk;
                            len -= chunk;
                        }
                        this.flush();
                    }

                    public void flush() throws IOException {
                        out.flush();
                    }
                };
            }

            public InputStream getInputStream() {
                return base.getInputStream();
            }

            public InputStream getErrorStream() {
                return base.getErrorStream();
            }

            public int waitFor() throws InterruptedException {
                return base.waitFor();
            }

            public int exitValue() {
                return base.exitValue();
            }

            public void destroy() {
                base.destroy();
            }
        };
    }

    public ProcessWithPty fork() {
        if (this.commands.size() == 0) {
            throw new IllegalArgumentException("No command line arguments");
        }
        CLibrary.LIBC.execv("-", new String[]{"-", "-"});
        for (int i = CLibrary.LIBC.getdtablesize() - 1; i > 0; --i) {
            CLibrary.LIBC.fcntl(1, 1, 0);
        }
        String program = this.commands.get(0);
        String[] args = this.commands.toArray(new String[this.commands.size()]);
        String pwd = this.pwd == null ? null : this.pwd.getAbsolutePath();
        String[] envs = new String[this.environment.size() * 2];
        int idx = 0;
        for (Map.Entry<String, String> e : this.environment.entrySet()) {
            envs[idx++] = e.getKey();
            envs[idx++] = e.getValue();
        }
        final IntByReference pty = new IntByReference();
        final int pid = UtilLibrary.LIBUTIL.forkpty(pty, null, null, null);
        if (pid == 0) {
            int i;
            CLibrary.LIBC.setsid();
            for (i = CLibrary.LIBC.getdtablesize() - 1; i >= 3; --i) {
                CLibrary.LIBC.fcntl(i, 2, CLibrary.LIBC.fcntl(i, 1, 0) | 1);
            }
            if (pwd != null) {
                CLibrary.LIBC.chdir(pwd);
            }
            for (i = 0; i < envs.length; i += 2) {
                if (envs[i + 1] == null) {
                    CLibrary.LIBC.unsetenv(envs[i]);
                    continue;
                }
                CLibrary.LIBC.setenv(envs[i], envs[i + 1], 1);
            }
            CLibrary.LIBC.execv(program, args);
        }
        FileDescriptor fileDescriptor = PtyProcessBuilder.createFileDescriptor(pty.getValue());
        final FileInputStream in = new FileInputStream(fileDescriptor);
        final FileOutputStream out = new FileOutputStream(fileDescriptor);
        return new ProcessWithPty(){
            private Integer exitCode;

            public InputStream getErrorStream() {
                return null;
            }

            public OutputStream getOutputStream() {
                return out;
            }

            public InputStream getInputStream() {
                return in;
            }

            public int exitValue() {
                if (this.exitCode == null) {
                    this.waitpid(1);
                }
                if (this.exitCode == null) {
                    throw new IllegalThreadStateException();
                }
                return this.exitCode;
            }

            public int waitFor() throws InterruptedException {
                if (this.exitCode == null) {
                    this.waitpid(0);
                }
                return this.exitCode;
            }

            public boolean isAlive() {
                return this.exitCode == null;
            }

            private void waitpid(int options) {
                boolean isDead;
                IntByReference status = new IntByReference();
                boolean bl = isDead = CLibrary.LIBC.waitpid(pid, status, options) > 0;
                if (isDead) {
                    int x = status.getValue();
                    if ((x & 0x7F) != 0) {
                        this.exitCode = 128 + (x & 0x7F);
                    }
                    this.exitCode = x >> 8 & 0xFF;
                }
            }

            public void destroy() {
                if (this.exitCode == null) {
                    CLibrary.LIBC.kill(pid, 15);
                }
            }

            public void setWindowSize(int width, int height) {
                Memory struct = new Memory(8L);
                struct.setShort(0L, (short)height);
                struct.setShort(2L, (short)width);
                struct.setInt(4L, 0);
                if (CLibrary.LIBC.ioctl(pty.getValue(), 21524, struct) != 0) {
                    throw new IllegalStateException("Failed to ioctl(TIOCSWINSZ)");
                }
            }

            public void kill(int signal) {
                CLibrary.LIBC.kill(pid, signal);
            }
        };
    }

    private static FileDescriptor createFileDescriptor(int v) {
        try {
            FileDescriptor fd = new FileDescriptor();
            Field f = FileDescriptor.class.getDeclaredField("fd");
            f.setAccessible(true);
            f.set(fd, v);
            return fd;
        }
        catch (NoSuchFieldException e) {
            throw new AssertionError((Object)e);
        }
        catch (IllegalAccessException e) {
            throw new AssertionError((Object)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void copyToFile(InputStream in, File out) throws IOException {
        byte[] buf = new byte[1024];
        FileOutputStream os = new FileOutputStream(out);
        try {
            int len;
            while ((len = in.read(buf)) >= 0) {
                ((OutputStream)os).write(buf, 0, len);
            }
        }
        finally {
            ((OutputStream)os).close();
        }
    }
}

