/*
 * Decompiled with CFR 0.152.
 */
package org.kohsuke.ajaxterm;

import java.io.IOException;
import java.io.Serializable;
import javax.servlet.http.HttpServletResponse;
import org.kohsuke.ajaxterm.Terminal;

public final class ScreenImage
implements Serializable {
    public final String screen;
    public final int timestamp;
    public final int cursorX;
    public final int cursorY;
    public final int screenX;
    public final int screenY;
    private static final long serialVersionUID = 1L;

    public ScreenImage(int timestamp, String screen, Terminal t) {
        this.timestamp = timestamp;
        this.screen = screen;
        if (t.showCursor) {
            this.cursorX = t.getCx();
            this.cursorY = t.getCy();
        } else {
            this.cursorY = -1;
            this.cursorX = -1;
        }
        this.screenX = t.width;
        this.screenY = t.height;
    }

    public void renderResponse(HttpServletResponse rsp) throws IOException {
        rsp.setContentType("application/xml;charset=UTF-8");
        if (this.cursorX != -1 || this.cursorY != -1) {
            rsp.addHeader("Cursor-X", String.valueOf(this.cursorX));
            rsp.addHeader("Cursor-Y", String.valueOf(this.cursorY));
        }
        rsp.addHeader("Screen-X", String.valueOf(this.screenX));
        rsp.addHeader("Screen-Y", String.valueOf(this.screenY));
        rsp.addHeader("Screen-Timestamp", String.valueOf(this.timestamp));
        rsp.getWriter().println(this.screen);
    }
}

