/*
 * Decompiled with CFR 0.152.
 */
package org.kohsuke.ajaxterm;

import java.io.Closeable;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.kohsuke.ajaxterm.ProcessWithPty;
import org.kohsuke.ajaxterm.PtyProcessBuilder;
import org.kohsuke.ajaxterm.ScreenImage;
import org.kohsuke.ajaxterm.Terminal;

public final class Session
extends Thread {
    private final ProcessWithPty childProcess;
    private final Terminal terminal;
    private final long time = System.currentTimeMillis();
    private long lastAccess;
    private final Reader in;
    private final Writer out;
    private static final Logger LOGGER = Logger.getLogger(Session.class.getName());

    public Session(int width, int height, String terminal, String ... commands) throws IOException {
        this(width, height, new PtyProcessBuilder().commands(commands).env("TERM", terminal).forkWithHelper());
    }

    public Session(int width, int height, ProcessWithPty childProcessWithTty) throws IOException {
        this.terminal = new Terminal(width, height);
        this.childProcess = childProcessWithTty;
        this.childProcess.setWindowSize(width, height);
        this.in = new InputStreamReader(this.childProcess.getInputStream());
        this.out = new OutputStreamWriter(this.childProcess.getOutputStream());
        this.setName("Terminal pump thread for " + childProcessWithTty);
        this.start();
    }

    public Terminal getTerminal() {
        return this.terminal;
    }

    public long getLastAccess() {
        return this.lastAccess;
    }

    public long getTime() {
        return this.time;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        char[] buf = new char[128];
        try {
            try {
                int len;
                while ((len = this.in.read(buf)) >= 0) {
                    this.terminal.write(new String(buf, 0, len));
                    String reply = this.terminal.read();
                    if (reply == null) continue;
                    this.out.write(reply);
                }
            }
            catch (IOException e) {
                if (!this.hasChildProcessFinished()) {
                    LOGGER.log(Level.WARNING, "Session pump thread is dead", e);
                }
            }
            finally {
                this.closeQuietly(this.in);
                this.closeQuietly(this.out);
            }
        }
        catch (Throwable e) {
            LOGGER.log(Level.WARNING, "Session pump thread is dead", e);
        }
    }

    private boolean hasChildProcessFinished() {
        try {
            this.childProcess.exitValue();
            return true;
        }
        catch (IllegalThreadStateException e) {
            return false;
        }
    }

    private void closeQuietly(Closeable c) {
        try {
            if (c != null) {
                c.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void handleUpdate(HttpServletRequest req, HttpServletResponse rsp) throws IOException, InterruptedException {
        this.handleUpdate(req.getParameter("k"), req.getParameter("c") != null, Integer.parseInt(req.getParameter("t"))).renderResponse(rsp);
    }

    public ScreenImage handleUpdate(String keys, boolean color, int clientTimestamp) throws IOException, InterruptedException {
        this.lastAccess = System.currentTimeMillis();
        this.write(keys);
        Thread.sleep(20L);
        this.terminal.setCssClass(this.isAlive() ? "" : "dead");
        return this.terminal.dumpHtml(color, clientTimestamp);
    }

    public void write(String k) throws IOException {
        if (k != null && k.length() != 0) {
            this.out.write(k);
            this.out.flush();
        }
    }

    public Process getChildProcess() {
        return this.childProcess;
    }

    public static String getAjaxTerm() {
        return "linux";
    }
}

