/*
 * Decompiled with CFR 0.152.
 */
package org.kohsuke.ajaxterm;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.kohsuke.ajaxterm.Esc;
import org.kohsuke.ajaxterm.ScreenImage;

public class Terminal {
    public char[] scr;
    public final int width;
    public final int height;
    private int st;
    private int sb;
    private int cx;
    private int cy;
    private int cx_bak;
    private int cy_bak;
    private boolean cl;
    private int sgr;
    private String buf;
    private String outbuf;
    private String last_html;
    private int last_html_timestamp;
    private int timestamp = 1000;
    public boolean showCursor;
    private String cssClass;
    private static final EscapeSequence NONE = new EscapeSequence(){

        public void handle(Terminal t, String s, Matcher m) {
        }
    };
    private static final Map<String, EscapeSequence> ESCAPE_SEQUENCES = new HashMap<String, EscapeSequence>();
    private static final Map<Pattern, EscapeSequence> REGEXP_ESCAPE_SEQUENCES = new HashMap<Pattern, EscapeSequence>();
    private static final Map<Character, CsiSequence> CSI_SEQUENCE = new HashMap<Character, CsiSequence>();
    private static final String HTML_TABLE;
    private static final String LATEN1_TABLE;
    private static final char EMPTY_CH = '\u0700';
    private static final Logger LOGGER;
    private static final String NO_CHANGE = "<idem/>";
    private static final String[] EMPTY_STRING_ARRAY;

    public Terminal(int width, int height) {
        this.width = width;
        this.height = height;
        this.reset();
    }

    public void setCssClass(String cssClass) {
        this.cssClass = cssClass;
    }

    public int getCx() {
        return this.cx;
    }

    public int getCy() {
        return this.cy;
    }

    @Esc(value={"\u001bc"})
    public void reset() {
        this.scr = new char[this.width * this.height];
        Arrays.fill(this.scr, '\u0700');
        this.st = 0;
        this.sb = this.height - 1;
        this.cx = 0;
        this.cx_bak = 0;
        this.cy = 0;
        this.cy_bak = 0;
        this.cl = false;
        this.sgr = 1792;
        this.showCursor = true;
        this.last_html = "";
        this.outbuf = "";
        this.buf = "";
        this.timestamp += 1000;
    }

    private int $(int y, int x) {
        return y * this.width + x;
    }

    public String peek(int y1, int y2) {
        return this.peek(y1, 0, y2, this.width);
    }

    public String peek(int y1, int x1, int y2, int x2) {
        int s = this.$(y1, x1);
        return new String(this.scr, s, this.$(y2, x2) - s);
    }

    public void poke(int y, int x, String s) {
        System.arraycopy(s.toCharArray(), 0, this.scr, this.$(y, x), s.length());
    }

    public void poke(int y, String s) {
        this.poke(y, 0, s);
    }

    public void zero(int y1, int x1, int y2, int x2) {
        int e = this.$(y2, x2);
        for (int i = this.$(y1, x1); i < e; ++i) {
            this.scr[i] = 1792;
        }
    }

    public void zero(int y1, int y2) {
        this.zero(y1, 0, y2, this.width);
    }

    public void scrollUp(int y1, int y2) {
        this.poke(y1, this.peek(y1 + 1, y2));
        this.zero(y2, y2);
    }

    public void scrollDown(int y1, int y2) {
        this.poke(y1 + 1, this.peek(y1, y2 - 1));
        this.zero(y1, y1);
    }

    public void scrollRight(int y, int x) {
        this.poke(y, x + 1, this.peek(y, x, y, this.width));
        this.zero(y, x, y, x);
    }

    @Esc(value={"\n", "\u000b", "\f"})
    public void cursorDown() {
        if (this.cy >= this.st && this.cy <= this.sb) {
            this.cl = false;
            int q = (this.cy + 1) / (this.sb + 1);
            if (q != 0) {
                this.scrollUp(this.st, this.sb);
                this.cy = this.sb;
            } else {
                this.cy = (this.cy + 1) % (this.sb + 1);
            }
        }
    }

    public void cursorRight() {
        if (this.cx + 1 >= this.width) {
            this.cl = true;
        } else {
            this.cx = (this.cx + 1) % this.width;
        }
    }

    public void echo(char c) {
        if (this.cl) {
            this.cursorDown();
            this.cx = 0;
        }
        this.scr[this.$((int)this.cy, (int)this.cx)] = (char)(this.sgr | c);
        this.cursorRight();
    }

    public void escape() {
        if (this.buf.length() > 32) {
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine("Unhandled escape sequence: " + this.buf.replaceAll("\u001b", "<ESC>"));
            }
            this.buf = "";
            return;
        }
        EscapeSequence es = ESCAPE_SEQUENCES.get(this.buf);
        if (es != null) {
            es.handle(this, this.buf, null);
            this.buf = "";
            return;
        }
        for (Map.Entry<Pattern, EscapeSequence> ent : REGEXP_ESCAPE_SEQUENCES.entrySet()) {
            Matcher m = ent.getKey().matcher(this.buf);
            if (!m.matches()) continue;
            ent.getValue().handle(this, this.buf, m);
            this.buf = "";
            return;
        }
    }

    public void write(String s) {
        ++this.timestamp;
        if (LOGGER.isLoggable(Level.FINEST)) {
            LOGGER.finest("Received: " + s);
        }
        for (int i = 0; i < s.length(); ++i) {
            char ch = s.charAt(i);
            if (this.buf.length() > 0 || ESCAPE_SEQUENCES.containsKey("" + ch)) {
                this.buf = this.buf + ch;
                this.escape();
                continue;
            }
            if (ch == '\u001b') {
                this.buf = this.buf + ch;
                continue;
            }
            this.echo(ch);
        }
    }

    public String read() {
        String b = this.outbuf;
        this.outbuf = null;
        return b;
    }

    public String dump() {
        StringBuilder buf = new StringBuilder(this.scr.length);
        for (char ch : this.scr) {
            buf.append((char)(ch & 0xFF));
        }
        return buf.toString();
    }

    public String dumpLatin1() {
        StringBuilder buf = new StringBuilder(this.scr.length);
        int i = 0;
        for (char ch : this.scr) {
            buf.append(LATEN1_TABLE.charAt(ch & 0xFF));
            if (++i % this.width != 0) continue;
            buf.append('\n');
        }
        return buf.toString();
    }

    private int pack(int fg, int bg, boolean cursor) {
        return (cursor ? 256 : 0) + (fg << 4) + bg;
    }

    public ScreenImage dumpHtml(boolean color, int clientTimestamp) {
        if (this.timestamp == clientTimestamp) {
            return new ScreenImage(clientTimestamp, NO_CHANGE, this);
        }
        StringBuilder r = new StringBuilder(this.cx * this.cy * 2);
        r.append("<pre class='term ");
        if (this.cssClass != null) {
            r.append(this.cssClass);
        }
        r.append("'>");
        int currentStatus = -1;
        int total = this.height * this.width;
        for (int i = 0; i < total; ++i) {
            int fg;
            int bg;
            int q = this.scr[i] / 256;
            if (color) {
                bg = q / 16;
                fg = q % 16;
            } else {
                bg = 1;
                fg = 7;
            }
            boolean cursor = this.$(this.cy, this.cx) == i;
            int p = this.pack(fg, bg, cursor);
            if (currentStatus != p) {
                currentStatus = p;
                if (i != 0) {
                    r.append("</span>");
                }
                r.append("<span class='f").append(fg).append(" b").append(bg);
                if (cursor) {
                    r.append(" cur");
                }
                r.append("'>");
            }
            int c = this.scr[i] % 256;
            switch (c) {
                case 60: {
                    r.append("&lt;");
                    break;
                }
                case 38: {
                    r.append("&amp;");
                    break;
                }
                default: {
                    r.append(HTML_TABLE.charAt(c));
                }
            }
            if ((i + 1) % this.width != 0) continue;
            r.append('\n');
        }
        r.append("</span></pre>");
        String str = r.toString();
        if (str.equals(this.last_html) && this.last_html_timestamp == clientTimestamp) {
            return new ScreenImage(clientTimestamp, NO_CHANGE, this);
        }
        this.last_html = str;
        this.last_html_timestamp = this.timestamp;
        return new ScreenImage(this.timestamp, str, this);
    }

    @Esc(value={"\u0005", "\u001b[c", "\u001b[0c", "\u001bZ"})
    public void esc_da() {
        this.outbuf = "\u001b[?6c";
    }

    @Esc(value={"\b"})
    public void esc_0x08() {
        this.cx = Math.max(0, this.cx - 1);
    }

    @Esc(value={"\t"})
    public void esc_0x09() {
        this.cx = (this.cx / 8 + 1) * 8 % this.width;
    }

    @Esc(value={"\r"})
    public void esc_0x0d() {
        this.cl = false;
        this.cx = 0;
    }

    @Esc(value={"\u0000", "\u0007", "\u000e", "\u000f", "\u001b#8", "\u001b=", "\u001b>", "\u001b(0", "\u001b(A", "\u001b(B", "\u001b]R", "\u001bD", "\u001bE", "\u001bH", "\u001bN", "\u001bO", "\u001ba", "\u001bn", "\u001bo"})
    public void noOp() {
    }

    @Esc(value={"\u001b7"})
    public void saveCursor() {
        this.cx_bak = this.cx;
        this.cy_bak = this.cy;
    }

    @Esc(value={"\u001b8"})
    public void restoreCursor() {
        this.cx = this.cx_bak;
        this.cy = this.cy_bak;
    }

    @Esc(value={"\u001bM"})
    public void escRi() {
        this.cy = Math.max(this.st, this.cy - 1);
        if (this.cy == this.st) {
            this.scrollDown(this.st, this.sb);
        }
    }

    public void csi_A(int[] i) {
        this.cy = Math.max(this.st, this.cy - this.defaultsTo(i, 1));
    }

    public void csi_B(int[] i) {
        this.cy = Math.min(this.sb, this.cy + this.defaultsTo(i, 1));
    }

    public void csi_C(int[] i) {
        this.cx = Math.min(this.width - 1, this.cx + this.defaultsTo(i, 1));
        this.cl = false;
    }

    public void csi_D(int[] i) {
        this.cx = Math.max(0, this.cx - this.defaultsTo(i, 1));
        this.cl = false;
    }

    private int defaultsTo(int[] args, int defaultValue) {
        return args.length == 0 ? defaultValue : args[0];
    }

    public void csi_E(int[] i) {
        this.csi_B(i);
        this.cx = 0;
        this.cl = false;
    }

    public void csi_F(int[] i) {
        this.csi_A(i);
        this.cx = 0;
        this.cl = false;
    }

    public void csi_G(int[] i) {
        this.cx = Math.min(this.width, i[0]) - 1;
    }

    public void csi_H(int[] i) {
        if (i.length < 2) {
            i = new int[]{1, 1};
        }
        this.cx = Math.min(this.width, i[1]) - 1;
        this.cy = Math.min(this.height, i[0]) - 1;
        this.cl = false;
    }

    public void csi_J(int[] i) {
        switch (this.defaultsTo(i, 0)) {
            case 0: {
                this.zero(this.cy, this.cx, this.height, 0);
                return;
            }
            case 1: {
                this.zero(0, 0, this.cx, this.cy);
                return;
            }
            case 2: {
                this.zero(0, 0, this.height, 0);
                return;
            }
        }
    }

    public void csi_K(int ... i) {
        switch (this.defaultsTo(i, 0)) {
            case 0: {
                this.zero(this.cy, this.cx, this.cy, this.width);
                return;
            }
            case 1: {
                this.zero(this.cy, 0, this.cy, this.cx);
                return;
            }
            case 2: {
                this.zero(this.cy, 0, this.cy, this.width);
                return;
            }
        }
    }

    public void csi_L(int[] args) {
        for (int i = 0; i < this.defaultsTo(args, 1); ++i) {
            if (this.cy >= this.sb) continue;
            this.scrollDown(this.cy, this.sb);
        }
    }

    public void csi_M(int[] args) {
        if (this.cy >= this.st && this.cy <= this.sb) {
            for (int i = 0; i < this.defaultsTo(args, 1); ++i) {
                this.scrollUp(this.cy, this.sb);
            }
        }
    }

    public void csi_P(int[] args) {
        int _cy = this.cy;
        int _cx = this.cx;
        String end = this.peek(this.cy, this.cx, this.cy, this.width);
        this.csi_K(0);
        this.poke(_cy, _cx, end.substring(this.defaultsTo(args, 1)));
    }

    public void csi_X(int[] args) {
        this.zero(this.cy, this.cx, this.cy, this.cx + args[0]);
    }

    public void csi_a(int[] args) {
        this.csi_C(args);
    }

    public void csi_c(int[] args) {
    }

    public void csi_d(int[] args) {
        this.cy = Math.min(this.height, args[0]) - 1;
    }

    public void csi_e(int[] args) {
        this.csi_B(args);
    }

    public void csi_f(int[] args) {
        this.csi_H(args);
    }

    public void csi_h(int[] args) {
        switch (args[0]) {
            case 25: {
                this.showCursor = true;
            }
        }
    }

    public void csi_l(int[] args) {
        switch (args[0]) {
            case 25: {
                this.showCursor = false;
            }
        }
    }

    public void csi_m(int[] args) {
        if (args.length == 0) {
            this.sgr = 1792;
            return;
        }
        for (int n : args) {
            if (n == 0 || n == 39 || n == 49 || n == 27) {
                this.sgr = 1792;
            }
            if (n == 1) {
                this.sgr |= 0x800;
            }
            if (n == 7) {
                this.sgr |= 0x7000;
            }
            if (30 <= n && n <= 37) {
                this.sgr = this.sgr & 0xF8FF | n - 30 << 8;
            }
            if (40 > n || n > 47) continue;
            this.sgr = this.sgr & 0xFFF | n - 40 << 12;
        }
    }

    public void csi_r(int[] args) {
        if (args.length < 2) {
            args = new int[]{0, this.height};
        }
        this.st = Math.min(this.height, args[0]) - 1;
        this.sb = Math.min(this.height, args[1]) - 1;
        this.sb = Math.max(this.sb, this.st);
    }

    public void csi_s(int[] args) {
        this.sb = Math.max(this.sb, this.st);
        this.saveCursor();
    }

    public void csi_u(int[] args) {
        this.restoreCursor();
    }

    static {
        for (final Method m : Terminal.class.getMethods()) {
            Esc esc = m.getAnnotation(Esc.class);
            if (esc != null) {
                for (String s : esc.value()) {
                    ESCAPE_SEQUENCES.put(s, new EscapeSequence(){

                        public void handle(Terminal t, String s, Matcher _) {
                            try {
                                m.invoke((Object)t, new Object[0]);
                            }
                            catch (IllegalAccessException e) {
                                throw new IllegalAccessError();
                            }
                            catch (InvocationTargetException e) {
                                throw new RuntimeException(e);
                            }
                        }
                    });
                }
            }
            if (!m.getName().startsWith("csi_") || m.getName().length() != 5) continue;
            CSI_SEQUENCE.put(Character.valueOf(m.getName().charAt(4)), new CsiSequence(1){

                void handle(Terminal t, int[] args) {
                    try {
                        m.invoke((Object)t, new Object[]{args});
                    }
                    catch (IllegalAccessException e) {
                        throw new IllegalAccessError();
                    }
                    catch (InvocationTargetException e) {
                        throw new RuntimeException(e);
                    }
                }
            });
        }
        REGEXP_ESCAPE_SEQUENCES.put(Pattern.compile("\u001b\\[\\??([0-9;]*)([@ABCDEFGHJKLMPXacdefghlmnqrstu`])"), new EscapeSequence(){

            public void handle(Terminal t, String _, Matcher m) {
                String s = m.group(1);
                CsiSequence seq = (CsiSequence)CSI_SEQUENCE.get(Character.valueOf(m.group(2).charAt(0)));
                if (seq != null) {
                    String[] tokens = s.split(";");
                    if (s.length() == 0) {
                        tokens = EMPTY_STRING_ARRAY;
                    }
                    int[] n = new int[tokens.length];
                    for (int i = 0; i < n.length; ++i) {
                        try {
                            n[i] = Integer.parseInt(tokens[i]);
                            continue;
                        }
                        catch (NumberFormatException e) {
                            n[i] = 0;
                        }
                    }
                    seq.handle(t, n);
                }
            }
        });
        REGEXP_ESCAPE_SEQUENCES.put(Pattern.compile("\u001c([^\u0007]+)\u0007"), NONE);
        CSI_SEQUENCE.put(Character.valueOf('@'), new CsiSequence(1){

            void handle(Terminal t, int[] args) {
                for (int i = 0; i < args[0]; ++i) {
                    t.scrollRight(t.cx, t.cy);
                }
            }
        });
        StringBuffer html = new StringBuffer(256);
        StringBuffer lat1 = new StringBuffer(256);
        for (int i = 0; i < 256; ++i) {
            if (i < 32) {
                lat1.append(' ');
                if (i == 10) {
                    html.append('\n');
                    continue;
                }
                html.append('\u00a0');
                continue;
            }
            if (i < 127 || 160 < i) {
                lat1.append((char)i);
                html.append((char)i);
                continue;
            }
            lat1.append('?');
            html.append('?');
        }
        HTML_TABLE = html.toString();
        LATEN1_TABLE = lat1.toString();
        LOGGER = Logger.getLogger(Terminal.class.getName());
        EMPTY_STRING_ARRAY = new String[0];
    }

    private static abstract class CsiSequence {
        final int arg2;

        protected CsiSequence(int arg2) {
            this.arg2 = arg2;
        }

        abstract void handle(Terminal var1, int[] var2);
    }

    private static interface EscapeSequence {
        public void handle(Terminal var1, String var2, Matcher var3);
    }
}

