/*
  $Id: Request.java 2885 2014-02-05 21:28:49Z dfisher $

  Copyright (C) 2003-2014 Virginia Tech.
  All rights reserved.

  SEE LICENSE FOR MORE INFORMATION

  Author:  Middleware Services
  Email:   middleware@vt.edu
  Version: $Revision: 2885 $
  Updated: $Date: 2014-02-05 16:28:49 -0500 (Wed, 05 Feb 2014) $
*/
package org.ldaptive;

import org.ldaptive.control.RequestControl;
import org.ldaptive.handler.IntermediateResponseHandler;

/**
 * Marker interface for all ldap requests.
 *
 * @author  Middleware Services
 * @version  $Revision: 2885 $ $Date: 2014-02-05 16:28:49 -0500 (Wed, 05 Feb 2014) $
 */
public interface Request extends Message<RequestControl>
{


  /**
   * Returns whether to follow referrals.
   *
   * @return  whether to follow referrals
   */
  boolean getFollowReferrals();


  /**
   * Returns the intermediate response handlers.
   *
   * @return  intermediate response handlers
   */
  IntermediateResponseHandler[] getIntermediateResponseHandlers();
}
