/*
  $Id$

  Copyright (C) 2003-2017 Virginia Tech.
  All rights reserved.

  SEE LICENSE FOR MORE INFORMATION

  Author:  Middleware Services
  Email:   middleware@vt.edu
  Version: $Revision$
  Updated: $Date$
*/
package org.ldaptive.auth;

import org.ldaptive.LdapException;

/**
 * Provides pre authentication handling of authentication requests.
 *
 * @author  Middleware Services
 * @version  $Revision$ $Date$
 */
public interface AuthenticationRequestHandler
{


  /**
   * Handle the request for an ldap authentication.
   *
   * @param  dn  distinguished name resolved for this request
   * @param  request  for this authentication event
   *
   * @throws  LdapException  if an error occurs handling an authentication
   * request
   */
  void handle(String dn, AuthenticationRequest request)
    throws LdapException;
}
