/*
  $Id: AuthenticationResultCode.java 2885 2014-02-05 21:28:49Z dfisher $

  Copyright (C) 2003-2014 Virginia Tech.
  All rights reserved.

  SEE LICENSE FOR MORE INFORMATION

  Author:  Middleware Services
  Email:   middleware@vt.edu
  Version: $Revision: 2885 $
  Updated: $Date: 2014-02-05 16:28:49 -0500 (Wed, 05 Feb 2014) $
*/
package org.ldaptive.auth;

/**
 * Enum to define authentication results.
 *
 * @author  Middleware Services
 * @version  $Revision: 2885 $ $Date: 2014-02-05 16:28:49 -0500 (Wed, 05 Feb 2014) $
 */
public enum AuthenticationResultCode {

  /** The configured authentication handler produced a result of true. */
  AUTHENTICATION_HANDLER_SUCCESS,

  /** The configured authentication handler produced a result of false. */
  AUTHENTICATION_HANDLER_FAILURE,

  /** The supplied credential was empty or null. */
  INVALID_CREDENTIAL,

  /** The configured DN resolver produced an empty or null value. */
  DN_RESOLUTION_FAILURE
}
