/*
  $Id: DnResolver.java 3146 2016-04-08 22:05:47Z daniel_fisher $

  Copyright (C) 2003-2014 Virginia Tech.
  All rights reserved.

  SEE LICENSE FOR MORE INFORMATION

  Author:  Middleware Services
  Email:   middleware@vt.edu
  Version: $Revision: 3146 $
  Updated: $Date: 2016-04-08 18:05:47 -0400 (Fri, 08 Apr 2016) $
*/
package org.ldaptive.auth;

import org.ldaptive.LdapException;

/**
 * Provides an interface for finding LDAP DNs with a user identifier.
 *
 * @author  Middleware Services
 * @version  $Revision: 3146 $ $Date: 2016-04-08 18:05:47 -0400 (Fri, 08 Apr 2016) $
 */
public interface DnResolver
{


  /**
   * Attempts to find the LDAP DN for the supplied user.
   *
   * @param  user  to find DN for
   *
   * @return  user DN
   *
   * @throws  LdapException  if an LDAP error occurs
   */
  String resolve(String user)
    throws LdapException;
}
