/*
  $Id: NoOpDnResolver.java 3146 2016-04-08 22:05:47Z daniel_fisher $

  Copyright (C) 2003-2014 Virginia Tech.
  All rights reserved.

  SEE LICENSE FOR MORE INFORMATION

  Author:  Middleware Services
  Email:   middleware@vt.edu
  Version: $Revision: 3146 $
  Updated: $Date: 2016-04-08 18:05:47 -0400 (Fri, 08 Apr 2016) $
*/
package org.ldaptive.auth;

import org.ldaptive.LdapException;

/**
 * Returns a DN that is the user identifier.
 *
 * @author  Middleware Services
 * @version  $Revision: 3146 $ $Date: 2016-04-08 18:05:47 -0400 (Fri, 08 Apr 2016) $
 */
public class NoOpDnResolver implements DnResolver, DnResolverEx
{


  /**
   * Returns the user as the DN.
   *
   * @param  user  to set as DN
   *
   * @return  user as DN
   *
   * @throws  LdapException  never
   */
  @Override
  public String resolve(final String user)
    throws LdapException
  {
    return resolve(new User(user));
  }


  /**
   * Returns the user as the DN.
   *
   * @param  user  to set as DN
   *
   * @return  user as DN
   *
   * @throws  LdapException  never
   */
  @Override
  public String resolve(final User user)
    throws LdapException
  {
    return user != null ? user.getIdentifier() : null;
  }


  /** {@inheritDoc} */
  @Override
  public String toString()
  {
    return String.format("[%s@%d]", getClass().getName(), hashCode());
  }
}
