/*
  $Id$

  Copyright (C) 2003-2017 Virginia Tech.
  All rights reserved.

  SEE LICENSE FOR MORE INFORMATION

  Author:  Middleware Services
  Email:   middleware@vt.edu
  Version: $Revision$
  Updated: $Date$
*/
package org.ldaptive.auth.ext;

import org.ldaptive.auth.AddControlAuthenticationRequestHandler;
import org.ldaptive.auth.User;
import org.ldaptive.control.PasswordPolicyControl;
import org.ldaptive.control.RequestControl;

/**
 * Adds the {@link PasswordPolicyControl} to the {@link
 * org.ldaptive.auth.AuthenticationRequest}.
 *
 * @author  Middleware Services
 * @version  $Revision$ $Date$
 */
public class PasswordPolicyAuthenticationRequestHandler
  extends AddControlAuthenticationRequestHandler
{


  /**
   * Creates a new password policy authentication request handler
   */
  public PasswordPolicyAuthenticationRequestHandler()
  {
    super(new ControlFactory()
    {


      @Override
      public RequestControl[] getControls(final String dn, final User user)
      {
        return new RequestControl[] {new PasswordPolicyControl()};
      }
    });
  }
}
