/*
  $Id: PasswordPolicyAuthenticationResponseHandler.java 3120 2015-10-01 15:50:02Z daniel_fisher $

  Copyright (C) 2003-2014 Virginia Tech.
  All rights reserved.

  SEE LICENSE FOR MORE INFORMATION

  Author:  Middleware Services
  Email:   middleware@vt.edu
  Version: $Revision: 3120 $
  Updated: $Date: 2015-10-01 11:50:02 -0400 (Thu, 01 Oct 2015) $
*/
package org.ldaptive.auth.ext;

import java.util.Calendar;
import org.ldaptive.auth.AuthenticationResponse;
import org.ldaptive.auth.AuthenticationResponseHandler;
import org.ldaptive.control.PasswordPolicyControl;

/**
 * Attempts to parse the authentication response message and set the account
 * state using data associated with a password policy control.
 *
 * @author  Middleware Services
 * @version  $Revision: 3120 $ $Date: 2015-10-01 11:50:02 -0400 (Thu, 01 Oct 2015) $
 */
public class PasswordPolicyAuthenticationResponseHandler
  implements AuthenticationResponseHandler
{


  /** {@inheritDoc} */
  @Override
  public void handle(final AuthenticationResponse response)
  {
    final PasswordPolicyControl ppc = (PasswordPolicyControl)
      response.getControl(PasswordPolicyControl.OID);
    if (ppc != null) {
      if (ppc.getError() != null) {
        response.setAccountState(
          new PasswordPolicyAccountState(ppc.getError()));
      } else {
        Calendar exp = null;
        if (ppc.getTimeBeforeExpiration() > 0) {
          exp = Calendar.getInstance();
          exp.add(Calendar.SECOND, ppc.getTimeBeforeExpiration());
        }
        if (exp != null || ppc.getGraceAuthNsRemaining() > 0) {
          response.setAccountState(
            new PasswordPolicyAccountState(exp, ppc.getGraceAuthNsRemaining()));
        }
      }
    }
  }
}
