/*
  $Id: NoOpOperationExceptionHandler.java 2885 2014-02-05 21:28:49Z dfisher $

  Copyright (C) 2003-2014 Virginia Tech.
  All rights reserved.

  SEE LICENSE FOR MORE INFORMATION

  Author:  Middleware Services
  Email:   middleware@vt.edu
  Version: $Revision: 2885 $
  Updated: $Date: 2014-02-05 16:28:49 -0500 (Wed, 05 Feb 2014) $
*/
package org.ldaptive.handler;

import org.ldaptive.Connection;
import org.ldaptive.LdapException;
import org.ldaptive.Request;
import org.ldaptive.Response;

/**
 * Returns a handler result containing the response passed to {@link
 * #handle(Connection, Request, Response)}.
 *
 * @param  <Q>  type of ldap request
 * @param  <S>  type of ldap response
 *
 * @author  Middleware Services
 * @version  $Revision: 2885 $ $Date: 2014-02-05 16:28:49 -0500 (Wed, 05 Feb 2014) $
 */
public class NoOpOperationExceptionHandler<Q extends Request, S>
  implements OperationExceptionHandler<Q, S>
{


  /** {@inheritDoc} */
  @Override
  public HandlerResult<Response<S>> handle(
    final Connection conn,
    final Q request,
    final Response<S> response)
    throws LdapException
  {
    return new HandlerResult<Response<S>>(response);
  }
}
