/*
  $Id: SearchEntryHandler.java 2885 2014-02-05 21:28:49Z dfisher $

  Copyright (C) 2003-2014 Virginia Tech.
  All rights reserved.

  SEE LICENSE FOR MORE INFORMATION

  Author:  Middleware Services
  Email:   middleware@vt.edu
  Version: $Revision: 2885 $
  Updated: $Date: 2014-02-05 16:28:49 -0500 (Wed, 05 Feb 2014) $
*/
package org.ldaptive.handler;

import org.ldaptive.Connection;
import org.ldaptive.LdapException;
import org.ldaptive.SearchEntry;
import org.ldaptive.SearchRequest;

/**
 * Provides post search handling of a search entry.
 *
 * @author  Middleware Services
 * @version  $Revision: 2885 $ $Date: 2014-02-05 16:28:49 -0500 (Wed, 05 Feb 2014) $
 */
public interface SearchEntryHandler extends Handler<SearchRequest, SearchEntry>
{


  /** {@inheritDoc} */
  @Override
  HandlerResult<SearchEntry> handle(
    Connection conn,
    SearchRequest request,
    SearchEntry entry)
    throws LdapException;


  /**
   * Initialize the search request for use with this entry handler.
   *
   * @param  request  to initialize for this entry handler
   */
  void initializeRequest(SearchRequest request);
}
