/*
  $Id: AbstractIntermediateResponse.java 3189 2016-11-01 21:21:43Z daniel_fisher $

  Copyright (C) 2003-2014 Virginia Tech.
  All rights reserved.

  SEE LICENSE FOR MORE INFORMATION

  Author:  Middleware Services
  Email:   middleware@vt.edu
  Version: $Revision: 3189 $
  Updated: $Date: 2016-11-01 17:21:43 -0400 (Tue, 01 Nov 2016) $
*/
package org.ldaptive.intermediate;

import org.ldaptive.control.ResponseControl;

/**
 * Base class for ldap intermediate response messages.
 *
 * @author  Middleware Services
 * @version  $Revision: 3189 $ $Date: 2016-11-01 17:21:43 -0400 (Tue, 01 Nov 2016) $
 */
public abstract class AbstractIntermediateResponse
  implements IntermediateResponse
{

  /** response oid. */
  private final String responseOid;

  /** response controls. */
  private final ResponseControl[] responseControls;

  /** message ID. */
  private final int messageId;


  /**
   * Creates a new abstract intermediate response.
   *
   * @param  oid  OID of this message
   * @param  c  response controls
   * @param  i  message id
   */
  public AbstractIntermediateResponse(
    final String oid,
    final ResponseControl[] c,
    final int i)
  {
    responseOid = oid;
    responseControls = c;
    messageId = i;
  }


  /** {@inheritDoc} */
  @Override
  public String getOID()
  {
    return responseOid;
  }


  /** {@inheritDoc} */
  @Override
  public ResponseControl[] getControls()
  {
    return responseControls;
  }


  /** {@inheritDoc} */
  @Override
  public ResponseControl getControl(final String oid)
  {
    if (getControls() != null) {
      for (ResponseControl c : getControls()) {
        if (c.getOID().equals(oid)) {
          return c;
        }
      }
    }
    return null;
  }


  /** {@inheritDoc} */
  @Override
  public int getMessageId()
  {
    return messageId;
  }
}
