/*
  $Id: Activator.java 3283 2018-09-27 20:34:18Z daniel_fisher $

  Copyright (C) 2003-2014 Virginia Tech.
  All rights reserved.

  SEE LICENSE FOR MORE INFORMATION

  Author:  Middleware Services
  Email:   middleware@vt.edu
  Version: $Revision: 3283 $
  Updated: $Date: 2018-09-27 16:34:18 -0400 (Thu, 27 Sep 2018) $
*/
package org.ldaptive.pool;

/**
 * Provides an interface for activating objects when they are checked out from
 * the pool.
 *
 * @param  <T>  type of object being pooled
 *
 * @author  Middleware Services
 * @version  $Revision: 3283 $ $Date: 2018-09-27 16:34:18 -0400 (Thu, 27 Sep 2018) $
 */
public interface Activator<T>
{


  /**
   * Activate the supplied object.
   *
   * @param  t  object
   *
   * @return  whether activation was successful
   */
  boolean activate(T t);
}
