/*
  $Id: AuthenticationRequestPropertyInvoker.java 3155 2016-07-28 22:26:01Z daniel_fisher $

  Copyright (C) 2003-2014 Virginia Tech.
  All rights reserved.

  SEE LICENSE FOR MORE INFORMATION

  Author:  Middleware Services
  Email:   middleware@vt.edu
  Version: $Revision: 3155 $
  Updated: $Date: 2016-07-28 18:26:01 -0400 (Thu, 28 Jul 2016) $
*/
package org.ldaptive.props;

import java.io.IOException;
import org.ldaptive.Credential;
import org.ldaptive.LdapUtils;

/**
 * Handles properties for {@link org.ldaptive.auth.AuthenticationRequest}.
 *
 * @author  Middleware Services
 * @version  $Revision: 3155 $ $Date: 2016-07-28 18:26:01 -0400 (Thu, 28 Jul 2016) $
 */
public class AuthenticationRequestPropertyInvoker
  extends AbstractPropertyInvoker
{


  /**
   * Creates a new authentication request property invoker for the supplied
   * class.
   *
   * @param  c  class that has setter methods
   */
  public AuthenticationRequestPropertyInvoker(final Class<?> c)
  {
    initialize(c);
  }


  /** {@inheritDoc} */
  @Override
  protected Object convertValue(final Class<?> type, final String value)
  {
    Object newValue = value;
    if (type != String.class) {
      if (Credential.class.isAssignableFrom(type)) {
        if (LdapUtils.isResource(value)) {
          try {
            newValue = new Credential(
              LdapUtils.readInputStream(LdapUtils.getResource(value)));
          } catch (IOException e) {
            throw new IllegalArgumentException(
              "Could not read resource: " + value, e);
          }
        } else {
          newValue = new Credential(value);
        }
      } else {
        newValue = convertSimpleType(type, value);
      }
    }
    return newValue;
  }
}
