/*
  $Id: CredentialConfigParser.java 2885 2014-02-05 21:28:49Z dfisher $

  Copyright (C) 2003-2014 Virginia Tech.
  All rights reserved.

  SEE LICENSE FOR MORE INFORMATION

  Author:  Middleware Services
  Email:   middleware@vt.edu
  Version: $Revision: 2885 $
  Updated: $Date: 2014-02-05 16:28:49 -0500 (Wed, 05 Feb 2014) $
*/
package org.ldaptive.props;

import java.util.regex.Matcher;

/**
 * Parses the configuration data associated with credential configs. The format
 * of the property string should be like:
 *
 * <pre>
   KeyStoreCredentialConfig
     {{trustStore=file:/tmp/my.truststore}{trustStoreType=JKS}}
 * </pre>
 *
 * <p>or</p>
 *
 * <pre>
   {{trustCertificates=file:/tmp/my.crt}}
 * </pre>
 *
 * @author  Middleware Services
 * @version  $Revision: 2885 $ $Date: 2014-02-05 16:28:49 -0500 (Wed, 05 Feb 2014) $
 */
public class CredentialConfigParser extends PropertyValueParser
{

  /** Credential config class found in the config. */
  protected static final String DEFAULT_CREDENTIAL_CONFIG_CLASS =
    "org.ldaptive.ssl.X509CredentialConfig";


  /**
   * Creates a new credential config parser.
   *
   * @param  config  containing configuration data
   */
  public CredentialConfigParser(final String config)
  {
    final Matcher credentialOnlyMatcher = CONFIG_PATTERN.matcher(config);
    final Matcher paramsOnlyMatcher = PARAMS_ONLY_CONFIG_PATTERN.matcher(
      config);
    if (credentialOnlyMatcher.matches()) {
      initialize(
        credentialOnlyMatcher.group(1).trim(),
        credentialOnlyMatcher.group(2).trim());
    } else if (paramsOnlyMatcher.matches()) {
      initialize(
        DEFAULT_CREDENTIAL_CONFIG_CLASS,
        paramsOnlyMatcher.group(1).trim());
    }
  }


  /**
   * Returns whether the supplied configuration data contains a credential
   * config.
   *
   * @param  config  containing configuration data
   *
   * @return  whether the supplied configuration data contains a credential
   * config
   */
  public static boolean isCredentialConfig(final String config)
  {
    return isConfig(config) || isParamsOnlyConfig(config);
  }
}
