/*
 * Decompiled with CFR 0.152.
 */
package org.ldaptive.provider.unboundid;

import com.unboundid.ldap.sdk.LDAPConnection;
import com.unboundid.ldap.sdk.LDAPConnectionOptions;
import com.unboundid.ldap.sdk.LDAPException;
import javax.net.SocketFactory;
import org.ldaptive.LdapException;
import org.ldaptive.LdapURL;
import org.ldaptive.ResultCode;
import org.ldaptive.provider.AbstractProviderConnectionFactory;
import org.ldaptive.provider.ConnectionException;
import org.ldaptive.provider.ProviderConfig;
import org.ldaptive.provider.unboundid.UnboundIDConnection;
import org.ldaptive.provider.unboundid.UnboundIDProviderConfig;

public class UnboundIDConnectionFactory
extends AbstractProviderConnectionFactory<UnboundIDProviderConfig> {
    private final SocketFactory socketFactory;
    private final LDAPConnectionOptions ldapOptions;

    public UnboundIDConnectionFactory(String url, UnboundIDProviderConfig config, SocketFactory factory, LDAPConnectionOptions options) {
        super(url, (ProviderConfig)config);
        this.socketFactory = factory;
        this.ldapOptions = options;
    }

    protected UnboundIDConnection createInternal(String url) throws LdapException {
        LdapURL ldapUrl = new LdapURL(url);
        UnboundIDConnection conn = null;
        boolean closeConn = false;
        try {
            LDAPConnection lc = new LDAPConnection(this.socketFactory, this.ldapOptions);
            conn = new UnboundIDConnection(lc, (UnboundIDProviderConfig)this.getProviderConfig());
            lc.connect(ldapUrl.getLastEntry().getHostname(), ldapUrl.getLastEntry().getPort());
        }
        catch (LDAPException e) {
            closeConn = true;
            throw new ConnectionException((Exception)((Object)e), ResultCode.valueOf((int)e.getResultCode().intValue()));
        }
        finally {
            if (closeConn) {
                try {
                    if (conn != null) {
                        conn.close(null);
                    }
                }
                catch (LdapException e) {
                    this.logger.debug("Problem tearing down connection", (Throwable)e);
                }
            }
        }
        return conn;
    }
}

