/*
 * Decompiled with CFR 0.152.
 */
package org.linuxforhealth.fhir.core;

import java.io.File;

public class CachedObjectHolder<T> {
    private String fileName;
    private long lastModified;
    private T cachedObject;

    public CachedObjectHolder(String fileName, T cachedObject) {
        this.setFileName(fileName);
        File f = new File(fileName);
        this.setLastModified(f.lastModified());
        this.setCachedObject(cachedObject);
    }

    public CachedObjectHolder(T cachedObject) {
        this.setCachedObject(cachedObject);
    }

    public String getFileName() {
        return this.fileName;
    }

    public void setFileName(String fileName) {
        this.fileName = fileName;
    }

    public long getLastModified() {
        return this.lastModified;
    }

    public void setLastModified(long lastModified) {
        this.lastModified = lastModified;
    }

    public T getCachedObject() {
        return this.cachedObject;
    }

    public void setCachedObject(T cachedObject) {
        this.cachedObject = cachedObject;
    }

    public boolean isStale() {
        if (this.fileName != null) {
            File f = new File(this.fileName);
            return !f.exists() || f.lastModified() > this.getLastModified();
        }
        return false;
    }
}

