/*
 * Decompiled with CFR 0.152.
 */
package org.linuxforhealth.fhir.core;

import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import javax.ws.rs.core.MediaType;

public class FHIRMediaType
extends MediaType {
    private static final String VERSION_40 = "4.0";
    private static final String VERSION_43 = "4.3";
    private static final String VERSION_401 = "4.0.1";
    private static final String VERSION_430 = "4.3.0";
    public static final String FHIR_VERSION_PARAMETER = "fhirVersion";
    public static final Set<String> ADVERTISED_FHIR_VERSIONS = Collections.unmodifiableSet(new LinkedHashSet<String>(Arrays.asList("4.0", "4.3")));
    public static final Set<String> SUPPORTED_FHIR_VERSIONS = Collections.unmodifiableSet(new LinkedHashSet<String>(Arrays.asList("4.0", "4.0.1", "4.3", "4.3.0")));
    private static final Map<String, String> fhirVersion40ParameterMap = Collections.singletonMap("fhirVersion", "4.0");
    private static final Map<String, String> fhirVersion43ParameterMap = Collections.singletonMap("fhirVersion", "4.3");
    public static final String SUBTYPE_FHIR_JSON = "fhir+json";
    public static final String APPLICATION_FHIR_JSON = "application/fhir+json";
    public static final MediaType APPLICATION_FHIR_JSON_TYPE = new MediaType("application", "fhir+json");
    public static final MediaType APPLICATION_FHIR_40_JSON_TYPE = new MediaType("application", "fhir+json", fhirVersion40ParameterMap);
    public static final MediaType APPLICATION_FHIR_43_JSON_TYPE = new MediaType("application", "fhir+json", fhirVersion43ParameterMap);
    public static final String SUBTYPE_FHIR_XML = "fhir+xml";
    public static final String APPLICATION_FHIR_XML = "application/fhir+xml";
    public static final MediaType APPLICATION_FHIR_XML_TYPE = new MediaType("application", "fhir+xml");
    public static final MediaType APPLICATION_FHIR_40_XML_TYPE = new MediaType("application", "fhir+json", fhirVersion40ParameterMap);
    public static final MediaType APPLICATION_FHIR_43_XML_TYPE = new MediaType("application", "fhir+json", fhirVersion43ParameterMap);
    public static final String SUBTYPE_JSON_PATCH = "json-patch+json";
    public static final String APPLICATION_JSON_PATCH = "application/json-patch+json";
    public static final MediaType APPLICATION_JSON_PATCH_TYPE = new MediaType("application", "json-patch+json");
    public static final String SUBTYPE_FHIR_NDJSON = "fhir+ndjson";
    public static final String APPLICATION_NDJSON = "application/fhir+ndjson";
    public static final MediaType APPLICATION_FHIR_NDJSON_TYPE = new MediaType("application", "fhir+ndjson");
    public static final String SUBTYPE_FHIR_PARQUET = "fhir+parquet";
    public static final String APPLICATION_PARQUET = "application/fhir+parquet";
    public static final MediaType APPLICATION_FHIR_PARQUET_TYPE = new MediaType("application", "fhir+parquet");
}

