/*
 * Decompiled with CFR 0.152.
 */
package org.linuxforhealth.fhir.core;

import java.io.UnsupportedEncodingException;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.time.ZonedDateTime;
import java.util.Base64;
import java.util.Date;
import java.util.TimeZone;

public class FHIRUtilities {
    private static final ThreadLocal<SimpleDateFormat> timestampSimpleDateFormat = new ThreadLocal<SimpleDateFormat>(){

        @Override
        public SimpleDateFormat initialValue() {
            SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS");
            format.setTimeZone(TimeZone.getTimeZone("GMT"));
            return format;
        }
    };

    public static String getObjectHandle(Object o) {
        return Integer.toHexString(System.identityHashCode(o));
    }

    public static String stripNamespaceIfPresentInDiv(String str) {
        int startIndex = str.indexOf("<div xmlns=");
        if (startIndex != -1) {
            int endIndex = str.indexOf(">", startIndex);
            String subString = str.substring(startIndex, endIndex + 1);
            return str.replace(subString, "<div>");
        }
        return str;
    }

    public static String stripNewLineWhitespaceIfPresentInDiv(String str) {
        int endIndex;
        int startIndex = str.indexOf("<div>");
        if (startIndex != -1 && (endIndex = str.indexOf("</div>", startIndex)) != -1) {
            String divContent = str.substring(startIndex + 5, endIndex);
            String divWithoutNewLine = divContent.replace("\\r", "").replace("\\n", "").replaceAll(">\\s*<", "><");
            String strNewLineStrippedInDiv = str.replace(divContent, divWithoutNewLine);
            return strNewLineStrippedInDiv;
        }
        return str;
    }

    public static String decode(String encodedString) {
        String decodedString = null;
        if (FHIRUtilities.isEncoded(encodedString)) {
            try {
                String withoutTag = encodedString.substring(5);
                byte[] bytes = withoutTag.getBytes("UTF-8");
                byte[] decodedBytes = Base64.getDecoder().decode(bytes);
                byte[] xor_bytes = new byte[decodedBytes.length];
                for (int i = 0; i < decodedBytes.length; ++i) {
                    xor_bytes[i] = (byte)(0x5F ^ decodedBytes[i]);
                }
                decodedString = new String(xor_bytes, "UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                throw new IllegalStateException("UTF-8 must be supported", e);
            }
        } else {
            decodedString = encodedString;
        }
        return decodedString;
    }

    public static boolean isEncoded(String s) {
        return s != null && s.startsWith("{xor}");
    }

    public static Timestamp convertToTimestamp(ZonedDateTime zdt) {
        return Timestamp.from(zdt.toInstant());
    }

    public static String formatTimestamp(Date date) {
        return timestampSimpleDateFormat.get().format(date);
    }
}

