/*
 * Decompiled with CFR 0.152.
 */
package org.linuxforhealth.fhir.core;

import org.linuxforhealth.fhir.core.FHIRVersionParam;

public enum ResourceType {
    RESOURCE("Resource", FHIRVersionParam.VERSION_40),
    BINARY("Binary", FHIRVersionParam.VERSION_40),
    BUNDLE("Bundle", FHIRVersionParam.VERSION_40),
    DOMAIN_RESOURCE("DomainResource", FHIRVersionParam.VERSION_40),
    ACCOUNT("Account", FHIRVersionParam.VERSION_40),
    ACTIVITY_DEFINITION("ActivityDefinition", FHIRVersionParam.VERSION_40),
    ADMINISTRABLE_PRODUCT_DEFINITION("AdministrableProductDefinition", FHIRVersionParam.VERSION_43),
    ADVERSE_EVENT("AdverseEvent", FHIRVersionParam.VERSION_40),
    ALLERGY_INTOLERANCE("AllergyIntolerance", FHIRVersionParam.VERSION_40),
    APPOINTMENT("Appointment", FHIRVersionParam.VERSION_40),
    APPOINTMENT_RESPONSE("AppointmentResponse", FHIRVersionParam.VERSION_40),
    AUDIT_EVENT("AuditEvent", FHIRVersionParam.VERSION_40),
    BASIC("Basic", FHIRVersionParam.VERSION_40),
    BIOLOGICALLY_DERIVED_PRODUCT("BiologicallyDerivedProduct", FHIRVersionParam.VERSION_40),
    BODY_STRUCTURE("BodyStructure", FHIRVersionParam.VERSION_40),
    CAPABILITY_STATEMENT("CapabilityStatement", FHIRVersionParam.VERSION_40),
    CARE_PLAN("CarePlan", FHIRVersionParam.VERSION_40),
    CARE_TEAM("CareTeam", FHIRVersionParam.VERSION_40),
    CATALOG_ENTRY("CatalogEntry", FHIRVersionParam.VERSION_40),
    CHARGE_ITEM("ChargeItem", FHIRVersionParam.VERSION_40),
    CHARGE_ITEM_DEFINITION("ChargeItemDefinition", FHIRVersionParam.VERSION_40),
    CITATION("Citation", FHIRVersionParam.VERSION_43),
    CLAIM("Claim", FHIRVersionParam.VERSION_40),
    CLAIM_RESPONSE("ClaimResponse", FHIRVersionParam.VERSION_40),
    CLINICAL_IMPRESSION("ClinicalImpression", FHIRVersionParam.VERSION_40),
    CLINICAL_USE_DEFINITION("ClinicalUseDefinition", FHIRVersionParam.VERSION_43),
    CODE_SYSTEM("CodeSystem", FHIRVersionParam.VERSION_40),
    COMMUNICATION("Communication", FHIRVersionParam.VERSION_40),
    COMMUNICATION_REQUEST("CommunicationRequest", FHIRVersionParam.VERSION_40),
    COMPARTMENT_DEFINITION("CompartmentDefinition", FHIRVersionParam.VERSION_40),
    COMPOSITION("Composition", FHIRVersionParam.VERSION_40),
    CONCEPT_MAP("ConceptMap", FHIRVersionParam.VERSION_40),
    CONDITION("Condition", FHIRVersionParam.VERSION_40),
    CONSENT("Consent", FHIRVersionParam.VERSION_40),
    CONTRACT("Contract", FHIRVersionParam.VERSION_40),
    COVERAGE("Coverage", FHIRVersionParam.VERSION_40),
    COVERAGE_ELIGIBILITY_REQUEST("CoverageEligibilityRequest", FHIRVersionParam.VERSION_40),
    COVERAGE_ELIGIBILITY_RESPONSE("CoverageEligibilityResponse", FHIRVersionParam.VERSION_40),
    DETECTED_ISSUE("DetectedIssue", FHIRVersionParam.VERSION_40),
    DEVICE("Device", FHIRVersionParam.VERSION_40),
    DEVICE_DEFINITION("DeviceDefinition", FHIRVersionParam.VERSION_40),
    DEVICE_METRIC("DeviceMetric", FHIRVersionParam.VERSION_40),
    DEVICE_REQUEST("DeviceRequest", FHIRVersionParam.VERSION_40),
    DEVICE_USE_STATEMENT("DeviceUseStatement", FHIRVersionParam.VERSION_40),
    DIAGNOSTIC_REPORT("DiagnosticReport", FHIRVersionParam.VERSION_40),
    DOCUMENT_MANIFEST("DocumentManifest", FHIRVersionParam.VERSION_40),
    DOCUMENT_REFERENCE("DocumentReference", FHIRVersionParam.VERSION_40),
    EFFECT_EVIDENCE_SYNTHESIS("EffectEvidenceSynthesis", FHIRVersionParam.VERSION_40, FHIRVersionParam.VERSION_43),
    ENCOUNTER("Encounter", FHIRVersionParam.VERSION_40),
    ENDPOINT("Endpoint", FHIRVersionParam.VERSION_40),
    ENROLLMENT_REQUEST("EnrollmentRequest", FHIRVersionParam.VERSION_40),
    ENROLLMENT_RESPONSE("EnrollmentResponse", FHIRVersionParam.VERSION_40),
    EPISODE_OF_CARE("EpisodeOfCare", FHIRVersionParam.VERSION_40),
    EVENT_DEFINITION("EventDefinition", FHIRVersionParam.VERSION_40),
    EVIDENCE("Evidence", FHIRVersionParam.VERSION_40),
    EVIDENCE_REPORT("EvidenceReport", FHIRVersionParam.VERSION_43),
    EVIDENCE_VARIABLE("EvidenceVariable", FHIRVersionParam.VERSION_40),
    EXAMPLE_SCENARIO("ExampleScenario", FHIRVersionParam.VERSION_40),
    EXPLANATION_OF_BENEFIT("ExplanationOfBenefit", FHIRVersionParam.VERSION_40),
    FAMILY_MEMBER_HISTORY("FamilyMemberHistory", FHIRVersionParam.VERSION_40),
    FLAG("Flag", FHIRVersionParam.VERSION_40),
    GOAL("Goal", FHIRVersionParam.VERSION_40),
    GRAPH_DEFINITION("GraphDefinition", FHIRVersionParam.VERSION_40),
    GROUP("Group", FHIRVersionParam.VERSION_40),
    GUIDANCE_RESPONSE("GuidanceResponse", FHIRVersionParam.VERSION_40),
    HEALTHCARE_SERVICE("HealthcareService", FHIRVersionParam.VERSION_40),
    IMAGING_STUDY("ImagingStudy", FHIRVersionParam.VERSION_40),
    IMMUNIZATION("Immunization", FHIRVersionParam.VERSION_40),
    IMMUNIZATION_EVALUATION("ImmunizationEvaluation", FHIRVersionParam.VERSION_40),
    IMMUNIZATION_RECOMMENDATION("ImmunizationRecommendation", FHIRVersionParam.VERSION_40),
    IMPLEMENTATION_GUIDE("ImplementationGuide", FHIRVersionParam.VERSION_40),
    INGREDIENT("Ingredient", FHIRVersionParam.VERSION_43),
    INSURANCE_PLAN("InsurancePlan", FHIRVersionParam.VERSION_40),
    INVOICE("Invoice", FHIRVersionParam.VERSION_40),
    LIBRARY("Library", FHIRVersionParam.VERSION_40),
    LINKAGE("Linkage", FHIRVersionParam.VERSION_40),
    LIST("List", FHIRVersionParam.VERSION_40),
    LOCATION("Location", FHIRVersionParam.VERSION_40),
    MANUFACTURED_ITEM_DEFINITION("ManufacturedItemDefinition", FHIRVersionParam.VERSION_43),
    MEASURE("Measure", FHIRVersionParam.VERSION_40),
    MEASURE_REPORT("MeasureReport", FHIRVersionParam.VERSION_40),
    MEDIA("Media", FHIRVersionParam.VERSION_40),
    MEDICATION("Medication", FHIRVersionParam.VERSION_40),
    MEDICATION_ADMINISTRATION("MedicationAdministration", FHIRVersionParam.VERSION_40),
    MEDICATION_DISPENSE("MedicationDispense", FHIRVersionParam.VERSION_40),
    MEDICATION_KNOWLEDGE("MedicationKnowledge", FHIRVersionParam.VERSION_40),
    MEDICATION_REQUEST("MedicationRequest", FHIRVersionParam.VERSION_40),
    MEDICATION_STATEMENT("MedicationStatement", FHIRVersionParam.VERSION_40),
    MEDICINAL_PRODUCT("MedicinalProduct", FHIRVersionParam.VERSION_40, FHIRVersionParam.VERSION_43),
    MEDICINAL_PRODUCT_AUTHORIZATION("MedicinalProductAuthorization", FHIRVersionParam.VERSION_40, FHIRVersionParam.VERSION_43),
    MEDICINAL_PRODUCT_CONTRAINDICATION("MedicinalProductContraindication", FHIRVersionParam.VERSION_40, FHIRVersionParam.VERSION_43),
    MEDICINAL_PRODUCT_DEFINITION("MedicinalProductDefinition", FHIRVersionParam.VERSION_43),
    MEDICINAL_PRODUCT_INDICATION("MedicinalProductIndication", FHIRVersionParam.VERSION_40, FHIRVersionParam.VERSION_43),
    MEDICINAL_PRODUCT_INGREDIENT("MedicinalProductIngredient", FHIRVersionParam.VERSION_40, FHIRVersionParam.VERSION_43),
    MEDICINAL_PRODUCT_INTERACTION("MedicinalProductInteraction", FHIRVersionParam.VERSION_40, FHIRVersionParam.VERSION_43),
    MEDICINAL_PRODUCT_MANUFACTURED("MedicinalProductManufactured", FHIRVersionParam.VERSION_40, FHIRVersionParam.VERSION_43),
    MEDICINAL_PRODUCT_PACKAGED("MedicinalProductPackaged", FHIRVersionParam.VERSION_40, FHIRVersionParam.VERSION_43),
    MEDICINAL_PRODUCT_PHARMACEUTICAL("MedicinalProductPharmaceutical", FHIRVersionParam.VERSION_40, FHIRVersionParam.VERSION_43),
    MEDICINAL_PRODUCT_UNDESIRABLE_EFFECT("MedicinalProductUndesirableEffect", FHIRVersionParam.VERSION_40, FHIRVersionParam.VERSION_43),
    MESSAGE_DEFINITION("MessageDefinition", FHIRVersionParam.VERSION_40),
    MESSAGE_HEADER("MessageHeader", FHIRVersionParam.VERSION_40),
    MOLECULAR_SEQUENCE("MolecularSequence", FHIRVersionParam.VERSION_40),
    NAMING_SYSTEM("NamingSystem", FHIRVersionParam.VERSION_40),
    NUTRITION_ORDER("NutritionOrder", FHIRVersionParam.VERSION_40),
    NUTRITION_PRODUCT("NutritionProduct", FHIRVersionParam.VERSION_43),
    OBSERVATION("Observation", FHIRVersionParam.VERSION_40),
    OBSERVATION_DEFINITION("ObservationDefinition", FHIRVersionParam.VERSION_40),
    OPERATION_DEFINITION("OperationDefinition", FHIRVersionParam.VERSION_40),
    OPERATION_OUTCOME("OperationOutcome", FHIRVersionParam.VERSION_40),
    ORGANIZATION("Organization", FHIRVersionParam.VERSION_40),
    ORGANIZATION_AFFILIATION("OrganizationAffiliation", FHIRVersionParam.VERSION_40),
    PACKAGED_PRODUCT_DEFINITION("PackagedProductDefinition", FHIRVersionParam.VERSION_43),
    PARAMETERS("Parameters", FHIRVersionParam.VERSION_40),
    PATIENT("Patient", FHIRVersionParam.VERSION_40),
    PAYMENT_NOTICE("PaymentNotice", FHIRVersionParam.VERSION_40),
    PAYMENT_RECONCILIATION("PaymentReconciliation", FHIRVersionParam.VERSION_40),
    PERSON("Person", FHIRVersionParam.VERSION_40),
    PLAN_DEFINITION("PlanDefinition", FHIRVersionParam.VERSION_40),
    PRACTITIONER("Practitioner", FHIRVersionParam.VERSION_40),
    PRACTITIONER_ROLE("PractitionerRole", FHIRVersionParam.VERSION_40),
    PROCEDURE("Procedure", FHIRVersionParam.VERSION_40),
    PROVENANCE("Provenance", FHIRVersionParam.VERSION_40),
    QUESTIONNAIRE("Questionnaire", FHIRVersionParam.VERSION_40),
    QUESTIONNAIRE_RESPONSE("QuestionnaireResponse", FHIRVersionParam.VERSION_40),
    REGULATED_AUTHORIZATION("RegulatedAuthorization", FHIRVersionParam.VERSION_43),
    RELATED_PERSON("RelatedPerson", FHIRVersionParam.VERSION_40),
    REQUEST_GROUP("RequestGroup", FHIRVersionParam.VERSION_40),
    RESEARCH_DEFINITION("ResearchDefinition", FHIRVersionParam.VERSION_40),
    RESEARCH_ELEMENT_DEFINITION("ResearchElementDefinition", FHIRVersionParam.VERSION_40),
    RESEARCH_STUDY("ResearchStudy", FHIRVersionParam.VERSION_40),
    RESEARCH_SUBJECT("ResearchSubject", FHIRVersionParam.VERSION_40),
    RISK_ASSESSMENT("RiskAssessment", FHIRVersionParam.VERSION_40),
    RISK_EVIDENCE_SYNTHESIS("RiskEvidenceSynthesis", FHIRVersionParam.VERSION_40, FHIRVersionParam.VERSION_43),
    SCHEDULE("Schedule", FHIRVersionParam.VERSION_40),
    SEARCH_PARAMETER("SearchParameter", FHIRVersionParam.VERSION_40),
    SERVICE_REQUEST("ServiceRequest", FHIRVersionParam.VERSION_40),
    SLOT("Slot", FHIRVersionParam.VERSION_40),
    SPECIMEN("Specimen", FHIRVersionParam.VERSION_40),
    SPECIMEN_DEFINITION("SpecimenDefinition", FHIRVersionParam.VERSION_40),
    STRUCTURE_DEFINITION("StructureDefinition", FHIRVersionParam.VERSION_40),
    STRUCTURE_MAP("StructureMap", FHIRVersionParam.VERSION_40),
    SUBSCRIPTION("Subscription", FHIRVersionParam.VERSION_40),
    SUBSCRIPTION_STATUS("SubscriptionStatus", FHIRVersionParam.VERSION_43),
    SUBSCRIPTION_TOPIC("SubscriptionTopic", FHIRVersionParam.VERSION_43),
    SUBSTANCE("Substance", FHIRVersionParam.VERSION_40),
    SUBSTANCE_DEFINITION("SubstanceDefinition", FHIRVersionParam.VERSION_43),
    SUBSTANCE_NUCLEIC_ACID("SubstanceNucleicAcid", FHIRVersionParam.VERSION_40, FHIRVersionParam.VERSION_43),
    SUBSTANCE_POLYMER("SubstancePolymer", FHIRVersionParam.VERSION_40, FHIRVersionParam.VERSION_43),
    SUBSTANCE_PROTEIN("SubstanceProtein", FHIRVersionParam.VERSION_40, FHIRVersionParam.VERSION_43),
    SUBSTANCE_REFERENCE_INFORMATION("SubstanceReferenceInformation", FHIRVersionParam.VERSION_40, FHIRVersionParam.VERSION_43),
    SUBSTANCE_SOURCE_MATERIAL("SubstanceSourceMaterial", FHIRVersionParam.VERSION_40, FHIRVersionParam.VERSION_43),
    SUBSTANCE_SPECIFICATION("SubstanceSpecification", FHIRVersionParam.VERSION_40, FHIRVersionParam.VERSION_43),
    SUPPLY_DELIVERY("SupplyDelivery", FHIRVersionParam.VERSION_40),
    SUPPLY_REQUEST("SupplyRequest", FHIRVersionParam.VERSION_40),
    TASK("Task", FHIRVersionParam.VERSION_40),
    TERMINOLOGY_CAPABILITIES("TerminologyCapabilities", FHIRVersionParam.VERSION_40),
    TEST_REPORT("TestReport", FHIRVersionParam.VERSION_40),
    TEST_SCRIPT("TestScript", FHIRVersionParam.VERSION_40),
    VALUE_SET("ValueSet", FHIRVersionParam.VERSION_40),
    VERIFICATION_RESULT("VerificationResult", FHIRVersionParam.VERSION_40),
    VISION_PRESCRIPTION("VisionPrescription", FHIRVersionParam.VERSION_40);

    private final String value;
    private final FHIRVersionParam introduced;
    private final FHIRVersionParam retired;

    private ResourceType(String value, FHIRVersionParam introduced) {
        this(value, introduced, null);
    }

    private ResourceType(String value, FHIRVersionParam introduced, FHIRVersionParam retired) {
        this.value = value;
        this.introduced = introduced;
        this.retired = retired;
    }

    public String value() {
        return this.value;
    }

    public FHIRVersionParam getIntroduced() {
        return this.introduced;
    }

    public FHIRVersionParam getRetired() {
        return this.retired;
    }

    public static ResourceType from(String value) {
        if (value == null) {
            return null;
        }
        switch (value) {
            case "EffectEvidenceSynthesis": {
                return EFFECT_EVIDENCE_SYNTHESIS;
            }
            case "MedicinalProduct": {
                return MEDICINAL_PRODUCT;
            }
            case "MedicinalProductAuthorization": {
                return MEDICINAL_PRODUCT_AUTHORIZATION;
            }
            case "MedicinalProductContraindication": {
                return MEDICINAL_PRODUCT_CONTRAINDICATION;
            }
            case "MedicinalProductIndication": {
                return MEDICINAL_PRODUCT_INDICATION;
            }
            case "MedicinalProductIngredient": {
                return MEDICINAL_PRODUCT_INGREDIENT;
            }
            case "MedicinalProductInteraction": {
                return MEDICINAL_PRODUCT_INTERACTION;
            }
            case "MedicinalProductManufactured": {
                return MEDICINAL_PRODUCT_MANUFACTURED;
            }
            case "MedicinalProductPackaged": {
                return MEDICINAL_PRODUCT_PACKAGED;
            }
            case "MedicinalProductPharmaceutical": {
                return MEDICINAL_PRODUCT_PHARMACEUTICAL;
            }
            case "MedicinalProductUndesirableEffect": {
                return MEDICINAL_PRODUCT_UNDESIRABLE_EFFECT;
            }
            case "RiskEvidenceSynthesis": {
                return RISK_EVIDENCE_SYNTHESIS;
            }
            case "SubstanceNucleicAcid": {
                return SUBSTANCE_NUCLEIC_ACID;
            }
            case "SubstancePolymer": {
                return SUBSTANCE_POLYMER;
            }
            case "SubstanceProtein": {
                return SUBSTANCE_PROTEIN;
            }
            case "SubstanceReferenceInformation": {
                return SUBSTANCE_REFERENCE_INFORMATION;
            }
            case "SubstanceSourceMaterial": {
                return SUBSTANCE_SOURCE_MATERIAL;
            }
            case "SubstanceSpecification": {
                return SUBSTANCE_SPECIFICATION;
            }
            case "Resource": {
                return RESOURCE;
            }
            case "Binary": {
                return BINARY;
            }
            case "Bundle": {
                return BUNDLE;
            }
            case "DomainResource": {
                return DOMAIN_RESOURCE;
            }
            case "Account": {
                return ACCOUNT;
            }
            case "ActivityDefinition": {
                return ACTIVITY_DEFINITION;
            }
            case "AdministrableProductDefinition": {
                return ADMINISTRABLE_PRODUCT_DEFINITION;
            }
            case "AdverseEvent": {
                return ADVERSE_EVENT;
            }
            case "AllergyIntolerance": {
                return ALLERGY_INTOLERANCE;
            }
            case "Appointment": {
                return APPOINTMENT;
            }
            case "AppointmentResponse": {
                return APPOINTMENT_RESPONSE;
            }
            case "AuditEvent": {
                return AUDIT_EVENT;
            }
            case "Basic": {
                return BASIC;
            }
            case "BiologicallyDerivedProduct": {
                return BIOLOGICALLY_DERIVED_PRODUCT;
            }
            case "BodyStructure": {
                return BODY_STRUCTURE;
            }
            case "CapabilityStatement": {
                return CAPABILITY_STATEMENT;
            }
            case "CarePlan": {
                return CARE_PLAN;
            }
            case "CareTeam": {
                return CARE_TEAM;
            }
            case "CatalogEntry": {
                return CATALOG_ENTRY;
            }
            case "ChargeItem": {
                return CHARGE_ITEM;
            }
            case "ChargeItemDefinition": {
                return CHARGE_ITEM_DEFINITION;
            }
            case "Citation": {
                return CITATION;
            }
            case "Claim": {
                return CLAIM;
            }
            case "ClaimResponse": {
                return CLAIM_RESPONSE;
            }
            case "ClinicalImpression": {
                return CLINICAL_IMPRESSION;
            }
            case "ClinicalUseDefinition": {
                return CLINICAL_USE_DEFINITION;
            }
            case "CodeSystem": {
                return CODE_SYSTEM;
            }
            case "Communication": {
                return COMMUNICATION;
            }
            case "CommunicationRequest": {
                return COMMUNICATION_REQUEST;
            }
            case "CompartmentDefinition": {
                return COMPARTMENT_DEFINITION;
            }
            case "Composition": {
                return COMPOSITION;
            }
            case "ConceptMap": {
                return CONCEPT_MAP;
            }
            case "Condition": {
                return CONDITION;
            }
            case "Consent": {
                return CONSENT;
            }
            case "Contract": {
                return CONTRACT;
            }
            case "Coverage": {
                return COVERAGE;
            }
            case "CoverageEligibilityRequest": {
                return COVERAGE_ELIGIBILITY_REQUEST;
            }
            case "CoverageEligibilityResponse": {
                return COVERAGE_ELIGIBILITY_RESPONSE;
            }
            case "DetectedIssue": {
                return DETECTED_ISSUE;
            }
            case "Device": {
                return DEVICE;
            }
            case "DeviceDefinition": {
                return DEVICE_DEFINITION;
            }
            case "DeviceMetric": {
                return DEVICE_METRIC;
            }
            case "DeviceRequest": {
                return DEVICE_REQUEST;
            }
            case "DeviceUseStatement": {
                return DEVICE_USE_STATEMENT;
            }
            case "DiagnosticReport": {
                return DIAGNOSTIC_REPORT;
            }
            case "DocumentManifest": {
                return DOCUMENT_MANIFEST;
            }
            case "DocumentReference": {
                return DOCUMENT_REFERENCE;
            }
            case "Encounter": {
                return ENCOUNTER;
            }
            case "Endpoint": {
                return ENDPOINT;
            }
            case "EnrollmentRequest": {
                return ENROLLMENT_REQUEST;
            }
            case "EnrollmentResponse": {
                return ENROLLMENT_RESPONSE;
            }
            case "EpisodeOfCare": {
                return EPISODE_OF_CARE;
            }
            case "EventDefinition": {
                return EVENT_DEFINITION;
            }
            case "Evidence": {
                return EVIDENCE;
            }
            case "EvidenceReport": {
                return EVIDENCE_REPORT;
            }
            case "EvidenceVariable": {
                return EVIDENCE_VARIABLE;
            }
            case "ExampleScenario": {
                return EXAMPLE_SCENARIO;
            }
            case "ExplanationOfBenefit": {
                return EXPLANATION_OF_BENEFIT;
            }
            case "FamilyMemberHistory": {
                return FAMILY_MEMBER_HISTORY;
            }
            case "Flag": {
                return FLAG;
            }
            case "Goal": {
                return GOAL;
            }
            case "GraphDefinition": {
                return GRAPH_DEFINITION;
            }
            case "Group": {
                return GROUP;
            }
            case "GuidanceResponse": {
                return GUIDANCE_RESPONSE;
            }
            case "HealthcareService": {
                return HEALTHCARE_SERVICE;
            }
            case "ImagingStudy": {
                return IMAGING_STUDY;
            }
            case "Immunization": {
                return IMMUNIZATION;
            }
            case "ImmunizationEvaluation": {
                return IMMUNIZATION_EVALUATION;
            }
            case "ImmunizationRecommendation": {
                return IMMUNIZATION_RECOMMENDATION;
            }
            case "ImplementationGuide": {
                return IMPLEMENTATION_GUIDE;
            }
            case "Ingredient": {
                return INGREDIENT;
            }
            case "InsurancePlan": {
                return INSURANCE_PLAN;
            }
            case "Invoice": {
                return INVOICE;
            }
            case "Library": {
                return LIBRARY;
            }
            case "Linkage": {
                return LINKAGE;
            }
            case "List": {
                return LIST;
            }
            case "Location": {
                return LOCATION;
            }
            case "ManufacturedItemDefinition": {
                return MANUFACTURED_ITEM_DEFINITION;
            }
            case "Measure": {
                return MEASURE;
            }
            case "MeasureReport": {
                return MEASURE_REPORT;
            }
            case "Media": {
                return MEDIA;
            }
            case "Medication": {
                return MEDICATION;
            }
            case "MedicationAdministration": {
                return MEDICATION_ADMINISTRATION;
            }
            case "MedicationDispense": {
                return MEDICATION_DISPENSE;
            }
            case "MedicationKnowledge": {
                return MEDICATION_KNOWLEDGE;
            }
            case "MedicationRequest": {
                return MEDICATION_REQUEST;
            }
            case "MedicationStatement": {
                return MEDICATION_STATEMENT;
            }
            case "MedicinalProductDefinition": {
                return MEDICINAL_PRODUCT_DEFINITION;
            }
            case "MessageDefinition": {
                return MESSAGE_DEFINITION;
            }
            case "MessageHeader": {
                return MESSAGE_HEADER;
            }
            case "MolecularSequence": {
                return MOLECULAR_SEQUENCE;
            }
            case "NamingSystem": {
                return NAMING_SYSTEM;
            }
            case "NutritionOrder": {
                return NUTRITION_ORDER;
            }
            case "NutritionProduct": {
                return NUTRITION_PRODUCT;
            }
            case "Observation": {
                return OBSERVATION;
            }
            case "ObservationDefinition": {
                return OBSERVATION_DEFINITION;
            }
            case "OperationDefinition": {
                return OPERATION_DEFINITION;
            }
            case "OperationOutcome": {
                return OPERATION_OUTCOME;
            }
            case "Organization": {
                return ORGANIZATION;
            }
            case "OrganizationAffiliation": {
                return ORGANIZATION_AFFILIATION;
            }
            case "PackagedProductDefinition": {
                return PACKAGED_PRODUCT_DEFINITION;
            }
            case "Patient": {
                return PATIENT;
            }
            case "PaymentNotice": {
                return PAYMENT_NOTICE;
            }
            case "PaymentReconciliation": {
                return PAYMENT_RECONCILIATION;
            }
            case "Person": {
                return PERSON;
            }
            case "PlanDefinition": {
                return PLAN_DEFINITION;
            }
            case "Practitioner": {
                return PRACTITIONER;
            }
            case "PractitionerRole": {
                return PRACTITIONER_ROLE;
            }
            case "Procedure": {
                return PROCEDURE;
            }
            case "Provenance": {
                return PROVENANCE;
            }
            case "Questionnaire": {
                return QUESTIONNAIRE;
            }
            case "QuestionnaireResponse": {
                return QUESTIONNAIRE_RESPONSE;
            }
            case "RegulatedAuthorization": {
                return REGULATED_AUTHORIZATION;
            }
            case "RelatedPerson": {
                return RELATED_PERSON;
            }
            case "RequestGroup": {
                return REQUEST_GROUP;
            }
            case "ResearchDefinition": {
                return RESEARCH_DEFINITION;
            }
            case "ResearchElementDefinition": {
                return RESEARCH_ELEMENT_DEFINITION;
            }
            case "ResearchStudy": {
                return RESEARCH_STUDY;
            }
            case "ResearchSubject": {
                return RESEARCH_SUBJECT;
            }
            case "RiskAssessment": {
                return RISK_ASSESSMENT;
            }
            case "Schedule": {
                return SCHEDULE;
            }
            case "SearchParameter": {
                return SEARCH_PARAMETER;
            }
            case "ServiceRequest": {
                return SERVICE_REQUEST;
            }
            case "Slot": {
                return SLOT;
            }
            case "Specimen": {
                return SPECIMEN;
            }
            case "SpecimenDefinition": {
                return SPECIMEN_DEFINITION;
            }
            case "StructureDefinition": {
                return STRUCTURE_DEFINITION;
            }
            case "StructureMap": {
                return STRUCTURE_MAP;
            }
            case "Subscription": {
                return SUBSCRIPTION;
            }
            case "SubscriptionStatus": {
                return SUBSCRIPTION_STATUS;
            }
            case "SubscriptionTopic": {
                return SUBSCRIPTION_TOPIC;
            }
            case "Substance": {
                return SUBSTANCE;
            }
            case "SubstanceDefinition": {
                return SUBSTANCE_DEFINITION;
            }
            case "SupplyDelivery": {
                return SUPPLY_DELIVERY;
            }
            case "SupplyRequest": {
                return SUPPLY_REQUEST;
            }
            case "Task": {
                return TASK;
            }
            case "TerminologyCapabilities": {
                return TERMINOLOGY_CAPABILITIES;
            }
            case "TestReport": {
                return TEST_REPORT;
            }
            case "TestScript": {
                return TEST_SCRIPT;
            }
            case "ValueSet": {
                return VALUE_SET;
            }
            case "VerificationResult": {
                return VERIFICATION_RESULT;
            }
            case "VisionPrescription": {
                return VISION_PRESCRIPTION;
            }
            case "Parameters": {
                return PARAMETERS;
            }
        }
        throw new IllegalArgumentException(value);
    }
}

