/*
 * Decompiled with CFR 0.152.
 */
package org.linuxforhealth.fhir.core;

import java.io.File;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.linuxforhealth.fhir.core.CachedObjectHolder;

public abstract class TenantSpecificFileBasedCache<T> {
    private static final Logger log = Logger.getLogger(TenantSpecificFileBasedCache.class.getName());
    private Map<String, CachedObjectHolder<T>> cache = new HashMap<String, CachedObjectHolder<T>>();
    private String cacheType = "<unknown>";

    public TenantSpecificFileBasedCache() {
    }

    public TenantSpecificFileBasedCache(String cacheType) {
        this();
        this.cacheType = cacheType;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearCache() {
        Map<String, CachedObjectHolder<T>> map = this.cache;
        synchronized (map) {
            this.cache.clear();
        }
    }

    public abstract String getCacheEntryFilename(String var1);

    public abstract T createCachedObject(File var1) throws Exception;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public T getCachedObjectForTenant(String tenantId) throws Exception {
        if (log.isLoggable(Level.FINEST)) {
            log.entering(this.getClass().getName(), "getCachedObjectForTenant");
        }
        try {
            Map<String, CachedObjectHolder<T>> map;
            CachedObjectHolder<Object> holder = this.cache.get(tenantId);
            if (holder == null || holder.isStale()) {
                map = this.cache;
                synchronized (map) {
                    holder = this.cache.get(tenantId);
                    if (holder != null && holder.isStale()) {
                        log.fine("Cached " + this.cacheType + " for tenant-id '" + tenantId + "' is stale, discarding...");
                        this.cache.remove(tenantId);
                        holder = null;
                    }
                    if (holder == null) {
                        String fileName = this.getCacheEntryFilename(tenantId);
                        File f = new File(fileName);
                        if (log.isLoggable(Level.FINE)) {
                            log.fine("Loading config file from " + f.getAbsolutePath());
                        }
                        Object cachedObject = null;
                        if (f.exists()) {
                            cachedObject = this.createCachedObject(f);
                        }
                        if (cachedObject != null) {
                            holder = new CachedObjectHolder<Object>(fileName, cachedObject);
                            this.cache.put(tenantId, holder);
                            log.fine("Loaded " + this.cacheType + " for tenant-id '" + tenantId + "' and added it to the cache.");
                        } else {
                            log.fine("Tenant-specific " + this.cacheType + " for tenant '" + tenantId + "' not found, skipping...");
                        }
                    }
                }
            }
            map = holder != null ? holder.getCachedObject() : null;
            return (T)map;
        }
        finally {
            if (log.isLoggable(Level.FINEST)) {
                log.exiting(this.getClass().getName(), "getCachedObjectForTenant");
            }
        }
    }
}

